#include "mbed.h"
#include "global.h"
#include "graphics.h"
#include "TMP36.h"
#include <cstdlib>
#include <vector>

bool loadedBullet = false;

template <typename T> void drawVector(vector<T> &listRef) 
{  
      for (int i = 0; i < listRef.size(); i++) 
         listRef[i]->draw(listRef[i]->getPosition()[0],listRef[i]->getPosition()[1]);  
} 

template <typename T> void updateVector(vector<T> &listRef) 
{  
      for (int i = 0; i < listRef.size(); i++) 
         listRef[i]->update();  
} 

void shoot(void){
    loadedBullet = true;
}

void setUpAccelerometer();
void setUpHardware();

//Initalize Parts used
uLCD_4DGL uLCD(p9,p10,p11);             // LCD Screen (tx, rx, reset)
Serial pc(USBTX,USBRX); //not used in this program
MMA8452 acc(p28,p27,40000);// Accelerometer (sda, sdc, rate)
TMP36 myTMP36(p15);//TmepReading
//Button Setup
PinDetect buttonA(p21); //End turn 
PinDetect buttonB(p22); // Dice change
PinDetect buttonC(p23);//Continue

//Acclerometer values
double x =0.0l;
double y =0.0l;
double z =0.0l;

int pos;
int seedAssist;


bool gameOver = false; //This is to check if the game is over or not in the while update loop

int main()
{
    setUpHardware();
    setUpAccelerometer();

    //Instaniating objects
    BobAlien BobObj1;
    BobAlien BobObj2;
    BobAlien BobObj3;
    AliceAlien AliceObj1;
    AliceAlien AliceObj2;
    AliceAlien AliceObj3;
    Ship shipObj;
    Bullet bulletObj;
    Rocket rocketObj;
    
    //Initializing derived pointers
    BobAlien * BobPtr1 = &BobObj1;
    BobAlien * BobPtr2 = &BobObj2;
    BobAlien * BobPtr3 = &BobObj3;
    AliceAlien * AlicePtr1 = &AliceObj1;
    AliceAlien * AlicePtr2 = &AliceObj2;
    AliceAlien * AlicePtr3 = &AliceObj3;
    Ship * shipPtr = &shipObj;
    Bullet * bulletPtr = &bulletObj;
    Rocket * rocketPtr = &rocketObj;
    
    //Base Pointers
    ScreenObjects * BobObjPtr1 = &BobObj1;
    ScreenObjects * BobObjPtr2 = &BobObj2;
    ScreenObjects * BobObjPtr3 = &BobObj3;
    ScreenObjects * AliceObjPtr1 = &AliceObj1;
    ScreenObjects * AliceObjPtr2 = &AliceObj2;
    ScreenObjects * AliceObjPtr3 = &AliceObj3;
    ScreenObjects * ShipObjPtr = &shipObj;
    ScreenObjects * BulletObjPtr = &bulletObj;
    ScreenObjects * RocketObjPtr = &rocketObj;
    
    
    vector<ScreenObjects *>ScreenObjectArray;
    
    //Pushing the values onto the vector
    ScreenObjectArray.push_back(BobObjPtr1);//0
    ScreenObjectArray.push_back(BobObjPtr2);//1
    ScreenObjectArray.push_back(BobObjPtr3);//2
    ScreenObjectArray.push_back(AliceObjPtr1);//3
    ScreenObjectArray.push_back(AliceObjPtr2);//4
    ScreenObjectArray.push_back(AliceObjPtr3);//5
    ScreenObjectArray.push_back(ShipObjPtr);//6
    ScreenObjectArray.push_back(BulletObjPtr);//7
    ScreenObjectArray.push_back(RocketObjPtr);//8
    //Ship Starting Position
    ScreenObjectArray[6]->setPosition(64,100);
    
   // seedAssist = abs(static_cast<int> (10000*myTMP36.read()) % 80+1);
    //Enemy Starting Positions
     //enemy 1
    ScreenObjectArray[0]->setPosition(10,10);
    ScreenObjectArray[0]->draw(ScreenObjectArray[0]->getPosition()[0],ScreenObjectArray[0]->getPosition()[1]);
    //uLCD.printf("%i",pos);
    //enemy2
    ScreenObjectArray[1]->setPosition(40,20);
    ScreenObjectArray[1]->draw(ScreenObjectArray[1]->getPosition()[0],ScreenObjectArray[1]->getPosition()[1]);
    //enemy3
    ScreenObjectArray[2]->setPosition(86,60);
    ScreenObjectArray[2]->draw(ScreenObjectArray[2]->getPosition()[0],ScreenObjectArray[2]->getPosition()[1]);
    //enemy4
    ScreenObjectArray[3]->setPosition(69,74);
    ScreenObjectArray[3]->draw(ScreenObjectArray[3]->getPosition()[0],ScreenObjectArray[3]->getPosition()[1]);
    //enemy5
    ScreenObjectArray[4]->setPosition(20,64);
    ScreenObjectArray[4]->draw(ScreenObjectArray[4]->getPosition()[0],ScreenObjectArray[4]->getPosition()[1]);
    //enemy6
    ScreenObjectArray[5]->setPosition(50,17);
    ScreenObjectArray[5]->draw(ScreenObjectArray[5]->getPosition()[0],ScreenObjectArray[5]->getPosition()[1]);
    
    //bulletPtr->move(*shipPtr);

    while(1) {
        drawVector(ScreenObjectArray);
        updateVector(ScreenObjectArray);
        
        
        /*bulleT.draw(bulleT.getPosition()[0],bulleT.getPosition()[1]);
        uLCD.printf("%i x, %i y",bulleT.getShipPositio()[0],bulleT.getShipPosition()[1]);
        bulleT.update();*/
        wait(.01);
        buttonA.attach_deasserted(&shoot);
         buttonA.setSampleFrequency();
        if(!acc.isXYZReady()) {
            wait(.01);
        } else {
            acc.readXYZGravity(&x,&y,&z);
            //uLCD.printf("%g\n",y);
            shipPtr->setDirection(shipPtr->move(y));
           
           
        }
    }
}



void setUpAccelerometer()
{
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
}

void setUpHardware(){
    //uLCD screen
    uLCD.baudrate(3000000);
    wait(0.3);
    //accelermoter
    acc.activate();
    //buttons
    buttonA.mode(PullDown);
    buttonB.mode(PullDown);
    buttonC.mode(PullDown);
    }
    