#include "LogDigitalOut.h"
#include "mbed.h"


LogDigitalOut::LogDigitalOut(PinName pin) : _pin(pin) {
    _pin = 0;
}
/*************************************************************
 * @fn void LogDigitalOut::CountUp()
 * @breaf 動作回数カウントアップ
 * @param None
 * @return None
 * @sa None
 * @detail off->onを検出し、カウントアップする
 ************************************************************/
void LogDigitalOut::CountUp() {
    if (buffer==0) {
        if (_pin) {
            count ++;
        }
    }
    buffer = _pin;
}
/** My HelloWorld class.
 *  Used for printing "Hello World" on USB serial.
 */
void LogDigitalOut::RatiosUp() {
    if (_pin) {
        ratios ++;
    }
}
void LogDigitalOut::ResetAccumulate() {
    count = 0;
    ratios = 0;
}
int LogDigitalOut::GetCount() {
    return count;
}
int LogDigitalOut::GetRatios() {
    return ratios;
}
int LogDigitalOut::Read() {
    return _pin;
}
void LogDigitalOut::Write(int volume) {
    _pin = volume;
}