#include "mbed.h"
#include "BMP180.h"
#include <math.h>
#include <stdio.h>

#define PIN_SDA D4
#define PIN_SCL D5
Serial pc(SERIAL_TX,SERIAL_RX,921600);
Serial xbee(D1,D0);
DigitalOut FET(D9);


int main(){
    float x8;
    FET=0;
    BMP180 bmp180(PIN_SDA,PIN_SCL);
    float pressure,temperature,altitude;
    xbee.printf("\rstart!\n\r");
    bmp180.Initialize(27,BMP180_OSS_ULTRA_HIGH_RESOLUTION);//27は府大の海抜高度
    xbee.printf("initialization complete!\n\r");

    while(1){
        if(bmp180.ReadData(&temperature,&pressure)){
          float x4,x5,x6,x7,a,b;
            a = pressure;
            b = temperature;
            x4 = 1019.11 / a; //海面気圧を気圧でわる
            x5 = powf(x4, 0.1902225); //5.257ぶんの1
            x6 = 273.15 + b; //絶対温度
            x7 = (x5 - 1) * x6;
            x8 = x7 / 0.0065;
            altitude = x8;
            
            
            xbee.printf("Altitude(m)\t:%.3f\n\r",altitude);
            xbee.printf("--------------------------------\n\r");
            wait(1);
            break;
    }else{
        xbee.printf("NO DATA\n\r");
        xbee.printf("---------------------------\n\r");
        wait(1);
        }
    }
        while(1){
            if(bmp180.ReadData(&temperature,&pressure)){
                float y4,y5,y6,y7,y8,c,d;
                float speed;
                
                c = pressure;
                d = temperature;
                y4 = 1019.11 / c; //海面気圧を気圧でわる
                y5 = powf(y4,0.1902225);
                y6 = 273.15 + d;
                y7 = (y5 - 1) * y6;
                y8 = y7 / 0.0065;
                altitude = y8;
                speed = (x8 - y8)/1;
                
                xbee.printf("Altitude(m)\t:%.3f\n\r",altitude);
                xbee.printf("Speed(m/s)\t:%.3f\n\r",speed);
                xbee.printf("--------------------------------\n\r");
                x8 = y8;
                wait(1);
                if(speed<=0){
                    break;
                    }}
                else{
                    xbee.printf("NO DATA\n\r");
                    wait(1);
                    }
           }         
    FET=1;
wait(20);
FET=0;
return 0;
}