#include "mbed.h"
#include "BMP180.h"
#include <stdio.h>
#include <math.h>

#define PIN_SDA D4
#define PIN_SCL D5

Serial pc(SERIAL_TX,SERIAL_RX,921600);//通信
BMP180 bmp180(PIN_SDA,PIN_SCL);//気圧センサーのピン
Serial xbee(A7,A2);//Xbeeのピン
DigitalOut FET1(D9);//FETのピン
DigitalOut FET2(D8);

int main(){
    float avalt,x8;
    float pressure,temperature,altitude;//気圧，気温，高度
    float v;
    int t=0;
    
    xbee.printf("\rstart!\n\r");//気圧センサースタート
    bmp180.Initialize(27,BMP180_OSS_ULTRA_HIGH_RESOLUTION);//27は府大の海抜高度
    xbee.printf("initialization complete!\n\r");//初期化完了
    
    while(1){
          float x4,x5,x6,x7,a,b;
          float sum=0,altitude[11];
          int r=0;
        for(int p=1;p<11;p++){
        if(bmp180.ReadData(&temperature,&pressure)){
            a = pressure;
            b = temperature;
            x4 = 1019.11 / a; //海面気圧を気圧でわる
            x5 = powf(x4, 0.1902225); //5.257ぶんの1
            x6 = 273.15 + b; //絶対温度
            x7 = (x5 - 1) * x6;
            x8 = x7 / 0.0065;
            altitude[p] = x8;
            sum=sum+altitude[p];
            r++;
        }else{
        xbee.printf("NO DATA\n\r");
        xbee.printf("---------------------------\n\r");
        wait(1);
            }
            
            avalt=sum/(float)r;
            xbee.printf("Altitude(m)\t:%.3f\n\r",avalt);
            xbee.printf("--------------------------------\n\r");
            break;

    }wait(3);
        }
        while(1){
                float y4,y5,y6,y7,c,d;
                float y8=avalt;
                float speed;
                float s=0;
                float alti[11];
                float average_alti;
                int e=0;
        for(int q=1;q<11;q++){
                if(bmp180.ReadData(&temperature,&pressure)){
                c = pressure;
                d = temperature;
                y4 = 1019.11 / c; //海面気圧を気圧でわる
                y5 = powf(y4,0.1902225);
                y6 = 273.15 + d;
                y7 = (y5 - 1) * y6;
                y8 = y7 / 0.0065;
                alti[q]= y8;
                 s=s+alti[q];
                xbee.printf("高度%d回目%f\n\r",q,alti[q]);
                xbee.printf("-------------------------------\n\r");
                e++;
                }else{
                xbee.printf("NO_Data\n\r");
                    }
                    
                average_alti=s/(float)e;
                speed = (avalt - average_alti)/3;
                
                xbee.printf("Altitude(m)\t:%.3f\n\r",average_alti);
                xbee.printf("Speed(m/s)\t:%.3f\n\r",speed);
                xbee.printf("-------------------------------\n\r");
                
                avalt=average_alti;
                printf("tの値は%d\n",t);
                if(speed<=0.5){
                    t=t+1;
                    }
                    if(t==3){
                        break;
                        }
            }wait(3);
            }return 0;
            }
