/**
 * Motor Driver TB6612 Control Library
 *
 * -- TB6612 is a device of the TOSHIBA. 
 *
 * Copyright (C) 2012 Junichi Katsu (JKSOFT) 
 */
 
 
#include "TB6612.h"
 
// TB6612 Class Constructor
TB6612::TB6612(PinName pwm, PinName fwd, PinName rev):
        _pwm(pwm), _fwd(fwd), _rev(rev) {
 
    _fwd = 0;
    _rev = 0;
    _pwm = 0.0;
    _pwm.period(0.001);
}
 
// Speed Control
//  arg
//   int speed -100 -- 0 -- 100
void TB6612::speed(int speed) {
        
    if( speed > 0 )
    {
        _pwm = ((float)speed) / 100.0;
        _fwd = 1;
        _rev = 0;
    }
    else if( speed < 0 )
    {
        _pwm = -((float)speed) / 100.0;
        _fwd = 0;
        _rev = 1;
    }
    else
    {
        _fwd = 1;
        _rev = 1;
    }
}
 
 
// Speed Control with time-out
//  arg
//   int speed -100 -- 0 -- 100
//   int time  0
void TB6612::move(int sspeed , int time)
{
    speed(sspeed);
    wait_ms(time);
}
 
            