
#include "ui.h"
#include <iostream>

UI::UI() :
        tUI(printtw,this,osPriorityNormal,1024) {
    newdataflags = 0;
    for (int i = 0; i < NUMIDS; i++) {
        idlist[i] = 0;
        buffarr[i] = 0;
    }
    
    //char* sync = "ABCD";
    //std::cout.write(sync, 4);
}

bool UI::regid(char id, unsigned int length) {

    //check if the id is already taken
    if (id < NUMIDS && !idlist[id]) {
        idlist[id] = length;
        buffarr[id] = new float[length];
        return true;
    } else
        return false;
}

bool UI::updateval(char id, float* buffer, unsigned int length) {

    //check if the id is registered, and has buffer of correct length
    if (id < NUMIDS && idlist[id] == length && buffarr[id] && !(newdataflags & (1<<id))) {
        for (int i = 0; i < length; i++)
            buffarr[id][i] = buffer[i];
        newdataflags |= (1<<id);
        return true;
    } else
        return false;
}

bool UI::updateval(char id, float value) {

    //check if the id is registered, and the old value has been written
    if (id < NUMIDS && idlist[id] == 1 && buffarr[id] && !(newdataflags & (1<<id))) {
        buffarr[id][0] = value;
        newdataflags |= (1<<id);
        return true;
    } else
        return false;

}

bool UI::unregid(char id) {
    if (id < NUMIDS) {
        idlist[id] = 0;
        if (buffarr[id])
            delete buffarr[id];
        return true;
    } else 
        return false;
}

void UI::printloop() {

    while(1) {
        //char* stuff = "asdf";
        char* sync = "ABCD";
        std::cout.write(sync, 4);
        
        //output num packets
        char numidstosend = 0;
        for (int id = 0; id < NUMIDS; id++)
            if (newdataflags & (1<<id))
                numidstosend++;
        std::cout.put(numidstosend);
        
        //send packets
        for (int id = 0; id < NUMIDS; id++) {
            if (newdataflags & (1<<id)) {
                std::cout.put(id);
                std::cout.write((char*)buffarr[id], 4*idlist[id]);
                newdataflags &= ~(1<<id);
            }
        }
        
        std::cout.flush();
        Thread::wait(200);
        
    }

}

