
#include "ai.h"
#include "rtos.h"
#include "globals.h"

AI::AI() :
    thr_AI(aithreadwrapper,this,osPriorityNormal,1024) {
    flag_terminate = false;
    //printf("aistart\r\n");
}

void AI::settarget(float targetX, float targetY, float targetTheta, bool targetfacing){
    targetlock.lock();
    target.x = targetX;
    target.y = targetY;
    target.theta = targetTheta;
    target.facing = targetfacing;
    targetlock.unlock();
}

void AI::settarget(Target targetin){
    targetlock.lock();
    target = targetin;
    targetlock.unlock();
}

AI::Target AI::gettarget(){
    targetlock.lock();
    Target temptarget = target;
    targetlock.unlock();
    return temptarget;
}

void AI::ai_thread () {
    /*
    //printf("aithreadstart\r\n");
    Thread::signal_wait(0x01);
    settarget(660, 400, PI/2, true);
    
    Thread::signal_wait(0x01);
    settarget(660, 570, PI, true);
    
    Thread::signal_wait(0x01);
    settarget(400, 870, PI, true);

    Thread::signal_wait(0x01);
    settarget(660, 870, PI, false);
    
    flag_terminate = true;
    */

    // goes to the mid
    Thread::signal_wait(0x01);
    settarget(1500, 1000, PI/2, true);

    // left roll
    Thread::signal_wait(0x01);
    settarget(500, 1700, PI/2, true);

    // mid
    Thread::signal_wait(0x01);
    settarget(1500, 1000, PI/2, true);

    // map
    Thread::signal_wait(0x01);
    settarget(1500, 1700, PI/2, true);

    // mid
    Thread::signal_wait(0x01);
    settarget(1500, 1000, -PI/2, true);

    // home
    Thread::signal_wait(0x01);
    settarget(500, 500, 0, true);

    Thread::signal_wait(0x01);
    flag_terminate = true;
    //OLED3 = true;

    while (true) {
        Thread::wait(osWaitForever);
    }
}