
#include "ui.h"
#include <iostream>
#include "system.h"

UI::UI() :
        tUI(printtw,this,osPriorityNormal,2048) {
    newdataflags = 0;
    for (int i = 0; i < NUMIDS; i++) {
        idlist[i] = 0;
        buffarr[i] = 0;
    }

}

bool UI::regid(char id, unsigned int length) {

    //check if the id is already taken
    if (id < NUMIDS && !idlist[id]) {
        idlist[id] = length;
        buffarr[id] = new float[length];
        return true;
    } else
        return false;
}

bool UI::updateval(char id, float* buffer, unsigned int length) {
    
    //check if the id is registered, and has buffer of correct length
    if (id < NUMIDS && idlist[id] == length && buffarr[id] && !(newdataflags & (1<<id))) {
        for (int i = 0; i < length; i++)
            buffarr[id][i] = buffer[i];
        newdataflags |= (1<<id);
        return true;
    } else{
        return false;
    }
}

bool UI::updateval(char id, float value) {

    //check if the id is registered, and the old value has been written
    if (id < NUMIDS && idlist[id] == 1 && buffarr[id] && !(newdataflags & (1<<id))) {
        buffarr[id][0] = value;
        newdataflags |= (1<<id);
        return true;
    } else
        return false;

}

bool UI::unregid(char id) {
    if (id < NUMIDS) {
        idlist[id] = 0;
        if (buffarr[id])
            delete buffarr[id];
        return true;
    } else
        return false;
}

void UI::printloop() {

#ifdef UION
    Thread::wait(3500);
#else
    Thread::wait(osWaitForever);
#endif

    char* sync = "ABCD";
    std::cout.write(sync, 4);
    //std::cout.flush();
    std::cout << std::endl;
    //printf("\r\n");

    while (1) {
    
        OLED3 = !OLED3;
    
        //send number of packets
        char numtosend = 0;
        for (int id = 0; id < NUMIDS; id++)
            if (newdataflags & (1<<id))
                numtosend++;
                
        std::cout.put(numtosend);

        //send packets
        for (char id = 0; id < NUMIDS; id++) {
            if (newdataflags & (1<<id)) {
                std::cout.put(id);
                std::cout.write((char*)buffarr[id], idlist[id] * sizeof(float));
                newdataflags &= ~(1<<id);
            }
        }
        
        std::cout << std::endl;
        //std::cout.flush();
        Thread::wait(200);
    }

}

