#include "system.h"

//Defining the externs
DigitalOut     OLED1(LED1);
DigitalOut     OLED2(LED2);
DigitalOut     OLED3(LED3);
DigitalOut     OLED4(LED4);

//nop style wait function
void nopwait(int ms){
while(ms--)
    for (volatile int i = 0; i < 24000; i++);
}

float cpupercent; //defining the extern
void measureCPUidle (void const* arg) {
    
    Timer timer;
    cpupercent = 0; //defined in system.h
    
    while(1) {
        timer.reset();
        timer.start();
        wait(1);
        
        int thistime = timer.read_us()-1000000;
        cpupercent = thistime;
    }
}