
#ifndef UI_H
#define UI_H

#include "rtos.h"

#define NUMIDS 32

class UI {
public:
    Thread tUI;
    
    UI();
    
    bool regid(char id, unsigned int length);
    bool updateval(char id, float* buffer, unsigned int length);
    bool updateval(char id, float value);
    bool unregid(char id);
    
private:
    Mutex printlock;
    char idlist[NUMIDS];
    float* buffarr[NUMIDS];
    volatile int newdataflags; //Only works for NUMID = 32
    
    void printloop();
    static void printtw(void const *arg){ ((UI*)arg)->printloop(); }
};

#endif //UI_H
