
#ifndef SYSTEM_H
#define SYSTEM_H

#include "globals.h"
#include "rtos.h"

//a type which is a pointer to a rtos thread function
typedef void (*tfuncptr_t)(void const *argument);

//---------------------
//Signal ticker stuff
#define SIGTICKARGS(thread, signal) \
    (tfuncptr_t) (&Signalsetter::callback), osTimerPeriodic, (void*)(new Signalsetter(thread, signal))

class Signalsetter {
public:
    Signalsetter(Thread& inthread, int insignal) :
            thread(inthread) {
        signal = insignal;
        //pc.printf("ptr saved as %#x \r\n", (int)(&(inthread)));
    }

    static void callback(void* thisin) {

        Signalsetter* fthis = (Signalsetter*)thisin;
        //pc.printf("callback will signal thread object at %#x \r\n", (int)(&(fthis->thread)));
        fthis->thread.signal_set(fthis->signal);
        //delete fthis; //this is useful for single fire tickers!
    }

private:
    Thread& thread;
    int signal;
};

//---------------------
//cpu usage measurement function
extern float cpupercent;
void measureCPUidle (void const* arg);

#endif
