#ifndef GLOBALS_H
#define GLOBALS_H

#include "mbed.h"

#define PI 3.14159265

//Robot constants
//const int encoderRevCount = 1856;
//const int wheelmm = 314;
//const int robotCircumference = 1256;

//Robot constants in mm
const int robot_width = 260;
const int encoderRevCount = 360;
const int wheelmm = 226;
const int robotCircumference = 816;

//Robot movement constants
const float fwdvarperunit = 0.005; //1 std dev = 7% //NEEDS TO BE MEASURED AGAIN!
const float varperang = 3E-5; //around 1 degree stddev per 180 turn
const float xyvarpertime = 0.001; //(very poorly) accounts for hitting things
const float angvarpertime = 0.001;

//sonar constants
static const float sonarvariance = 0.005;

//Arena constants
struct pos {
    int x;
    int y;
};
const pos beaconpos[] = {{3000, 1000},{0,0}, {0,2000}};

//System constants
const int PREDICTPERIOD = 20; //ms

//High speed serial port
extern Serial pc;

//I2C mutex
//extern Mutex i2c_rlock;
//extern Mutex i2c_wlock;


// IR angle calc
#define RELI_BOUND_LOW          4
#define RELI_BOUND_HIGH         25

// Localization estimate tolerences
#define POSITION_TOR            50
#define ANGLE_TOR               0.15

// motion control
#define MOVE_SPEED              30
#define MAX_STEP_RATIO          0.10 //maximum change in the speed
//#define TRACK_RATE              10       // +- rate for each wheel when tracking

// Task suspend periods
#define IR_TURRET_PERIOD        200
#define MOTION_UPDATE_PERIOD    20

#endif