#ifndef _RF12B_H
#define _RF12B_H

#include "mbed.h"
#include <queue>

enum rfmode_t{RX, TX};

class RF12B {
public:
    /* Constructor */
    RF12B(PinName SDI,
          PinName SDO,
          PinName SCK,
          PinName NCS,
          PinName NIRQ);
          
          
    /* Reads a packet of data. Returns false if read failed. Use available() to check how much space to allocate for buffer */
    bool read(unsigned char* data, unsigned int size);

    /* Reads a byte of data from the receive buffer 
        Returns 0xFF if there is no data */
    unsigned char read();

    /* Transmits a packet of data */
    void write(unsigned char* data, unsigned char length);
    void write(unsigned char data); /* 1-byte packet */
    void write(std::queue<char> &data, int length = -1); /* sends a whole queue */
    
    /* Returns the packet length if data is available in the receive buffer, 0 otherwise*/
    unsigned int available();

protected:
    /* Receive FIFO buffer */
    std::queue<unsigned char> fifo;
    std::queue<unsigned char> temp; //for storing stuff mid-packet
    
    /* SPI module */
    SPI spi;
    
    /* Other digital pins */
    DigitalOut NCS;
    InterruptIn NIRQ;
    DigitalIn NIRQ_in;
    //DigitalOut rfled;
    
    rfmode_t mode;

    /* Initialises the RF12B module */
    void init();

    /* Write a command to the RF Module */
    unsigned int writeCmd(unsigned int cmd);
    
    /* Sends a byte of data across RF */
    void send(unsigned char data);
    
    /* Switch module between receive and transmit modes */
    void changeMode(rfmode_t mode);
    
    /* Interrupt routine for data reception */
    void rxISR();
    
    /* Tell the RF Module this packet is received and wait for the next */
    void resetRX();
    
    /* Return the RF Module Status word */
    unsigned int status();
    
    /* Calculate CRC8 */
    unsigned char crc8(unsigned char crc, unsigned char data);
};

#endif /* _RF12B_H */