#ifndef TSH_H
#define TSH_H

#include "rtos.h"

//Thread Safe Hardware

class TSI2C : public I2C {
public:

    TSI2C( PinName sda,
           PinName scl,
           const char* name=NULL )
            : I2C(sda, scl, name) { }


    int read( int address,
              char* data,
              int    length,
              bool repeated = false ) {

        rlock.lock();
        int retval = I2C::read(address, data, length, repeated);
        rlock.unlock();

        return retval;
    }

    int read(int ack) {
        rlock.lock();
        int retval = I2C::read(ack);
        rlock.unlock();

        return retval;
    }

    int write( int address,
               const char*    data,
               int length,
               bool repeated = false ) {

        wlock.lock();
        int retval = I2C::write(address, data, length, repeated);
        wlock.unlock();

        return retval;
    }

    int write(int data) {
        wlock.lock();
        int retval = I2C::write(data);
        wlock.unlock();

        return retval;
    }

private:
    Mutex rlock;
    Mutex wlock;
};

#endif