#ifndef MOTORS_H
#define MOTORS_H

#include "mbed.h"
#include "TSH.h"

class Motors {
public:
    Motors(TSI2C &i2cin);//, Mutex );
    //Motors(I2C &i2cin);

    //Functions declaration
    void disableAcceleration();
    void resetEncoders();
    int getEncoder1();
    int getEncoder2();
    void move(int distance, int speed);
    void turn(int angle, int speed);
    int getSignOfInt(int direction);
    void stop();
    void setSpeed(int speed);
    void setSpeed(int speed1, int speed2);
    void setMode(int mode);
    float encoderToDistance(int encoder);
    int distanceToEncoder(float distance);
    void sendCommand(char command);
    void sendCommand(char command1, char command2 );
    int get4Bytes(char command);
    void coastStop(void);


private:
    I2C& i2c;
    //Mutex&

    //Constants declaration
    static const int md25Address = 0xB0;
    static const char cmdSetMotor1 = 0x00;
    static const char cmdSetMotor2 = 0x01;
    static const char cmdByte = 0x10;
    static const char cmdSetMode = 0x0F;
    static const char cmdSetAcceleration = 0x0E;
    static const char cmdResetEncoders = 0x20;
    static const char cmdGetEncoder1 = 0x02;
    static const char cmdGetEncoder2 = 0x06;
    static const char cmdDisableAcceleration = 0x30;
};

#endif
