#include "mbed.h"
#include "rtos.h"
#include "TSH.h"
#include "Kalman.h"
#include "globals.h"
#include "motors.h"
#include "math.h"
#include "system.h"
#include "geometryfuncs.h"
#include "motion.h"
#include "ai.h"
#include "ui.h"
#include "front_arms.h"
#include "motion.h"

//#include <iostream>

//Interface declaration
Serial pc(USBTX, USBRX); // tx, rx




bool Colour = 1; // 1 for red, 0 for blue
pos beaconpos[] = {{3000, 1000},{0,0}, {0,2000}}; //predefined red start

DigitalIn StartTrig(p12);
DigitalIn ColourToggle(p22); //high for red, low for blue(purple)
Ticker StopTicker;

Motors motors;
UI ui;
Kalman kalman(motors,ui,p23,p14,p14,p14,p15,p15,p15,p5,p6,p7,p8,p11);
AI ai;
Motion motion(motors, ai, kalman);

void vMotorThread(void const *argument);
void vPrintState(void const *argument);
void motion_thread(void const *argument);
void vStop (void);

//Main loop
int main() {
    AnalogIn ObsAvoidPin(p20);
    // no motor motions till we pull the trig
    ai.flag_motorStop = true;
    Colour = !(ObsAvoidPin > 0.5);
    OLED3 = Colour;
    //nopwait(1000);
    //Colour = ColourToggle;
    // re-defines beacon positions by the toggle switch
    kalman.statelock.lock();
    if (true) {
        beaconpos[0].x = 3000;
        beaconpos[0].y = 1000;
        beaconpos[1].x = 0;
        beaconpos[1].y = 0;
        beaconpos[2].x = 0;
        beaconpos[2].y = 2000;
        //beaconpos[] = {{3000, 1000},{0,0}, {0,2000}};
    } else {
        beaconpos[0].x = 0;
        beaconpos[0].y = 1000;
        beaconpos[1].x = 3000;
        beaconpos[1].y = 0;
        beaconpos[2].x = 3000;
        beaconpos[2].y = 2000;
        //beaconpos[] = {{0, 1000},{3000,0}, {3000,2000}};
    }
    kalman.statelock.unlock();

    pc.baud(115200);
    ArmsEnable();
    ArmsClose();


    //Init kalman, this should be done in the mid of the arena before the game starts
    kalman.KalmanInit();

    //Thread tMotorThread(vMotorThread,NULL,osPriorityNormal,256);
    Thread tUpdateState(vPrintState,NULL,osPriorityNormal,1024);


    pc.printf("We got to main! ;D\r\n");
    if (Colour)
        printf("I'm in Red \n\r");
    else
        printf("I'm in Blue \n\r");

    //REMEMBERT TO PUT PULL UP RESISTORS ON I2C!!!!!!!!!!!!!!
    while (1) {
        // we use main loop to estimate the cpu usage

        osThreadSetPriority (osThreadGetId(), osPriorityIdle);

        Timer timer;
        ui.regid(10, 1);

        while (1) {
            timer.reset();
            timer.start();
            nopwait(1000);

            ui.updateval(10, timer.read_us());
        }

        // do nothing
        //Thread::wait(osWaitForever);
    }
}

void AI::ai_thread () {

    motors.accelerationRegister = 1;
    /*
    //printf("aithreadstart\r\n");
    Thread::signal_wait(0x01);
    settarget(660, 400, PI/2, true);

    Thread::signal_wait(0x01);
    settarget(660, 570, PI, true);

    Thread::signal_wait(0x01);
    settarget(400, 870, PI, true);

    Thread::signal_wait(0x01);
    settarget(660, 870, PI, false);

    flag_terminate = true;
    */

    printf("Waiting for the trigger pull ....\r\n");

    // wait for the start triger
    while (!StartTrig) {
        Thread::wait(10);
    };

    printf("GO! \r\n");
    kalman.KalmanReset();
    Thread::wait(100);



    // attach a 87 seconds stop timer


    //REPLACE TICKER!!!!
    StopTicker.attach(&vStop, 87);


    // starts motors
    ai.flag_motorStop = false;

    // no override
    ai.flag_manOverride = false;


//if (Colour){
    // strat 1 RED ==================================
    ArmsOpen();
    //Thread::wait(500);

    // goto middle x
    settarget(1500, 250, PI/2, true,Colour, 35);
    Thread::signal_wait(0x01);
    Thread::wait(2000);

    // to palm tree
    settarget(1500, 1000, PI, true,Colour, 35);
    Thread::signal_wait(0x01);
    Thread::wait(4000);

    // run over totem
    settarget(840,1000,PI, true,Colour, 80);
    motors.accelerationRegister = 0;
    Thread::wait(5000);
    //Thread::signal_wait(0x01);

    while (hypot(kalman.X(0) - 1.1f, kalman.X(1) - 1.0f) < 0.10) {
        // to palm tree
        settarget(1500, 1000, PI, false,Colour, 35);
        Thread::signal_wait(0x01);
        Thread::wait(4000);

        // run over totem
        settarget(840,1000,PI, true,Colour, 80);
        motors.accelerationRegister = 0;
        Thread::wait(5000);
    }
    Thread::signal_wait(0x01);

    motors.accelerationRegister = 1;
   
    // back to ship
    settarget(220,1000,0,true,Colour, 50);
    Thread::signal_wait(0x01);
    
    ArmsClose();
    
    settarget(840,1000,PI, true,Colour, 40);
    Thread::signal_wait(0x01);
    
     
     
     settarget(220,1000,PI,true,Colour, 40);
    Thread::signal_wait(0x01);
    
     settarget(840,1000,PI,false,Colour, 40);
    Thread::signal_wait(0x01);
    
   
//}

    /*else{
        // strat 1 BLUE ==================================
        // goto middle x
        settarget(3000-1500, 250, PI/2, true);
        Thread::signal_wait(0x01);
        Thread::wait(2000);

        // to palm tree
        settarget(3000-1500, 1000, 0, true);
        Thread::signal_wait(0x01);
        Thread::wait(2000);

        // run over totem
        settarget(3000-640,1000,0, true);
        Thread::signal_wait(0x01);
        Thread::wait(2000);

        // back to ship
        settarget(3000-220,780,0,true);
        Thread::signal_wait(0x01);
        Thread::wait(2000);
    }
    */
    /*
    // going from ship to ship for the remaining secs
        while (true){
        // back to home, RED
        settarget(500,400,PI,true);
        Thread::signal_wait(0x01);
        Thread::wait(2000);

        // back to ship, BLUE
        settarget(500,1600,0,true);
        Thread::signal_wait(0x01);
        Thread::wait(2000);
        }
        */

    // terminate thread, stopps motors permanently
    ai.flag_terminate = true;
    while (true) {
        Thread::wait(osWaitForever);
    }


    // end of strat 1 ===========================
}


void vMotorThread(void const *argument) {
    motors.resetEncoders();
    while (1) {
        motors.setSpeed(20,20);
        Thread::wait(2000);
        motors.stop();
        Thread::wait(5000);
        motors.setSpeed(-20,-20);
        Thread::wait(2000);
        motors.stop();
        Thread::wait(5000);
        motors.setSpeed(-20,20);
        Thread::wait(2000);
        motors.stop();
        Thread::wait(5000);
        motors.setSpeed(20,-20);
        Thread::wait(2000);
        motors.stop();
        Thread::wait(5000);
    }
}


void vPrintState(void const *argument) {
    float state[3];
    float SonarMeasures[3];
    float IRMeasures[3];

    Thread::wait(5000);
    while (1) {
        kalman.statelock.lock();
        state[0] = kalman.X(0);
        state[1] = kalman.X(1);
        state[2] = kalman.X(2);
        SonarMeasures[0] = kalman.SonarMeasures[0];
        SonarMeasures[1] = kalman.SonarMeasures[1];
        SonarMeasures[2] = kalman.SonarMeasures[2];
        IRMeasures[0] = kalman.IRMeasures[0];
        IRMeasures[1] = kalman.IRMeasures[1];
        IRMeasures[2] = kalman.IRMeasures[2];
        kalman.statelock.unlock();
        pc.printf("\r\n");
        pc.printf("current: %0.4f %0.4f %0.4f \r\n", state[0]*1000, state[1]*1000,state[2]*180/PI);
        pc.printf("Sonar: %0.4f %0.4f %0.4f \r\n",SonarMeasures[0]*1000,SonarMeasures[1]*1000,SonarMeasures[2]*1000);
        pc.printf("IR   : %0.4f %0.4f %0.4f \r\n",IRMeasures[0]*180/PI,IRMeasures[1]*180/PI,IRMeasures[2]*180/PI);
        Thread::wait(100);
    }
}

void vStop (void) {
//    while (true) {
    motors.coastStop();
    ai.flag_motorStop = true;
    // terminate thread, stopps motors permanently
    ai.flag_terminate = true;
//    };
}