#ifndef MOTORS_H
#define MOTORS_H

#include "mbed.h"
#include "QEI.h"
#include "PID.h"
#include "TSH.h"

class Motors {

public:
    Motors();
    Motors(TSI2C &i2cin);

    //Functions declaration
    void resetEncoders();
    int getEncoder1();
    int getEncoder2();
    void move(int distance, int speed);
    void turn(int angle, int speed);
    int getSignOfInt(int direction);
    void setSpeed(int speed);
    void setSpeed(int speed1, int speed2);
    void stop();
    void setMode(int mode);
    int encoderToDistance(int encoder);
    int distanceToEncoder(int distance);
    void sendCommand(char command);
    void sendCommand(char command1, char command2 );
    void speedRegulatorTask();
    float _debug1;
    float _debug2;
    int accelerationRegister;   //turns on acceleration control
    void coastStop();

private:
    
    void _setSpeed(int speed1, int speed2);
    void _stop();
    void _stop(int motor1, int motor2);
    QEI Encoder1;
    QEI Encoder2;
    DigitalOut Motor1A;
    DigitalOut Motor1B;
    DigitalOut Motor2A;
    DigitalOut Motor2B;
    PwmOut Motor1Enable;
    PwmOut Motor2Enable;
    int _motorSpeed1;
    int _motorSpeed2;
    PID PIDControllerMotor1;
    PID PIDControllerMotor2;
    int _lastEncoder1;
    int _lastEncoder2;
    int _pidDataBufferIndex;
    int _accelerationSpeed1;
    int _accelerationSpeed2;
    int _enableSpeed;
    Ticker _ticker;

};

#endif
