#ifndef GLOBALS_H
#define GLOBALS_H

#include "mbed.h"
#define PI 3.14159265


//#define ROBOT_SECONDARY

//enables ui
//#define UION

#ifdef ROBOT_SECONDARY
//Secondary Robot constants in mm
const int robot_width = 260;
const int encoderRevCount = 360;
const int wheelmm = 229;
const int robotCircumference = 816;


#else
#define ROBOT_PRIMARY
// invert echo polarity for primary
#define SONAR_ECHO_INV
// Primary Robot constants
const int robot_width = 390;
const int encoderRevCount = 1856;
const int wheelmm = 308;
const int robotCircumference = 1150;
#endif



//Robot movement constants
const float fwdvarperunit = 0.01; //1 std dev = 7% //NEEDS TO BE MEASURED AGAIN!
const float varperang = 0.01; //around 1 degree stddev per 180 turn
const float xyvarpertime = 0.0005; //(very poorly) accounts for hitting things
const float angvarpertime = 0.001;

//sonar constants
static const float sonarvariance = 0.005;

//IR constants
static const float IRvariance = 0.001;

//Arena constants
struct pos {
    int x;
    int y;
};

//beacon positions
extern pos beaconpos[];

//Colour
extern bool Colour; // 1 for red, 0 for blue

//System constants
const int PREDICTPERIOD = 20; //ms

//High speed serial port
extern Serial pc;

//I2C mutex
//extern Mutex i2c_rlock;
//extern Mutex i2c_wlock;


// IR angle calc
#define RELI_BOUND_LOW          4
#define RELI_BOUND_HIGH         25

// Movement target tolerances
#define POSITION_TOR            20  // in mm
#define ANGLE_TOR               0.06 // in rad

// motion control

#ifndef MOVE_SPEED_DEF
#define MOVE_SPEED_DEF
static int MOVE_SPEED = 35;
#endif

#define MAX_STEP_RATIO          0.10 //maximum change in the speed
//#define TRACK_RATE              10       // +- rate for each wheel when tracking

#ifdef ROBOT_PRIMARY
#define FWD_MOVE_P 20//18
#define SPIN_MOVE_P 7//5.8
#else
#define FWD_MOVE_P 3.2
#define SPIN_MOVE_P 4
#endif

// Task suspend periods
#define IR_TURRET_PERIOD        200
#define MOTION_UPDATE_PERIOD    20

#endif