#define BEACON_2
#include "defines.h"
#include "mbed.h"
#include "RF12B.h"


PwmOut IRled(p21);

Serial pc(USBTX, USBRX); // tx, rx

RF12B RF_Beacon(p5, p6, p7, p8, p9, p30);    //RF module

void turnON (void);
void turnOFF (void);

// interrupt driven
Timeout toggle;

char data_in;

int main() {
    RF_Beacon.setCode(CODE);
    IRled.period_us(T_CARRIER);
    toggle.attach_us(&turnON, 1000);
    pc.printf("Beacon Side \n");
    while (1) {
    }
}

void turnON (void) {
    IRled.pulsewidth_us(0);     // note: the IR led is ON when this is low
    toggle.attach_us(&turnOFF, T_CARRIER * ON_CYCLE);
}

void turnOFF (void) {
    IRled.pulsewidth_us(13);    // note: the IR led is ON when this is low
    toggle.attach_us(&turnON, T_CARRIER * OFF_CYCLE);
}