
/* Constructor */
#include "RFSerial.h"

RFSerial::RFSerial(PinName _SDI,
                   PinName _SDO,
                   PinName _SCK,
                   PinName _NCS,
                   PinName _NIRQ,
                   PinName _TRIG)
:RF12B(_SDI, _SDO, _SCK, _NCS, _NIRQ, _TRIG) {
    
}

// Stream implementation functions
int RFSerial::_putc(int value) {
    RF12B::write((unsigned char) value);
    return value;
}
int RFSerial::_getc() {
    if(available()) {
        return RF12B::read();
    } else {
        return EOF;
    }
}