#include "mbed.h"
#include "GPS.h"
#include "TextLCD.h"
GPS gps(PA_11,PA_12);
I2C i2c_lcd(D14,D15); 
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2); 
int main() 
{
    lcd.setMode(TextLCD::DispOn);
    lcd.setBacklight(TextLCD::LightOff);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    lcd.setAddress(0,0);
    lcd.printf("Initial GPS...\n");
  
    while(1){
        if(gps.sample())
        {
            lcd.setAddress(0,1);
            lcd.printf("%6.3f,%7.3f",gps.latitude,gps.longitude);
        }
        else
        {
            lcd.setAddress(0,1);
            lcd.printf("GPS not valid");
        }
        wait(0.5);
    }
}    
            