#include "mbed.h"
#include "EthernetInterface.h"
//#include <UDPSocket.h>

#define LED_NUM 23
#define LED_GLOBAL 4 // brightness 0-31
#define LED_FREQ 500000 // spi

#define SPI_MOSI    PTC6
//#define SPI_MOSI    PTD2
#define SPI_MISO    PTC7
#define SPI_SCK     PTC5
//#define SPI_SCK     PTD1

 
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut myled(LED1);
DigitalOut myled1(LED2);

int led_buf[LED_NUM];

void dotStar () {
    int i;

    // start frame
    for (i = 0; i < 4; i ++) {
        spi.write(0);
    }
    // led frame
    for (i = 0; i < LED_NUM; i ++) {
        spi.write((7<<5) | LED_GLOBAL);
        spi.write((led_buf[i] >> 16) & 0xff); // B
        spi.write((led_buf[i] >> 8) & 0xff); // G
        spi.write(led_buf[i] & 0xff); // R
    }
    // end frame
    for (i = 0; i < 4; i ++) {
        spi.write(1);
    }
}

// Network interface
EthernetInterface net;

void dot_red(){
    for (int i = 0; i < LED_NUM; i ++) {
//        int c = ((color + i) % 7) + 1;
        led_buf[i] = 0xff0000;
    }
    dotStar();
}
void dot_blue(){
    for (int i = 0; i < LED_NUM; i ++) {
//        int c = ((color + i) % 7) + 1;
        led_buf[i] = 0x00ff00;
    }
    dotStar();
}
void dot_green(){
    for (int i = 0; i < LED_NUM; i ++) {
//        int c = ((color + i) % 7) + 1;
        led_buf[i] = 0x0000ff;
    }
    dotStar();
}


// Socket demo
int main() {
    // Bring up the ethernet interface
    printf("Ethernet socket example\n");
    net.connect();
    
    // needed vars
    int i, c;
    int color = 1;
    myled1 = 0;
    myled = 1;
    spi.frequency(LED_FREQ);
    
    // first run of led color out: BLUE
    for (int i = 0; i < LED_NUM; i ++) {
        c = ((color + i) % 7) + 1;
        led_buf[i] = 0xffff00;
    }
    dotStar();
    myled = !myled;
    myled1 = !myled1;
    color ++;
    if (color > 7) color = 1;
    wait(0.2);
    
    // Show the network address
    const char *ip = net.get_ip_address();
    printf("IP address is: %s\n", ip ? ip : "No IP");

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    UDPSocket socket;
    socket.open(&net);
//    socket.connect("10.200.1.20", 4242);

    // net params
    const char* host = "10.200.1.123";
    uint16_t port = 4242;
    
    
    // set up the endpoint
//    Endpoint controller;
//    controller.set_address("10.200.1.20", 4242);
    SocketAddress address(&net, host, port);

    // Send a simple http request
    char sbuffer[] = "GET / HTTP/1.1\r\nHost: www.arm.com\r\n\r\n";
//    int scount = socket.send(sbuffer, sizeof sbuffer);
    int scount = socket.sendto(host, port, sbuffer, sizeof sbuffer);
    printf("sent %d [%.*s]\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
//    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    int rcount = socket.recvfrom(&address, rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);

    for (i = 0; i < LED_NUM; i ++) {
        c = ((color + i) % 7) + 1;
        led_buf[i] = 0x0000ff;
    }
    dotStar();
    myled = !myled;
    myled1 = !myled1;
    color ++;
    if (color > 7) color = 1;
    wait(0.2);
    
    // Ok hell yea.  Connection established, enter main loop serving artnet
    while(1) {
        // get a command
        char rbuffer[64];
        int rcount = socket.recvfrom(&address, rbuffer, sizeof rbuffer);
        
        // service it
        switch (rbuffer[0]) {
            case 'r':
                NVIC_SystemReset();
                break;
            case 'g':
                dot_green();
                break;
            case 'b':
                dot_blue();
                break;
        }
    }
    
    
    
    // Close the socket to return its memory and bring down the network interface
    socket.close();

    // Bring down the ethernet interface
    net.disconnect();
    printf("Done\n");
}
