#include "mbed.h"
#include "BLE.h"
#include "ButtonService.h"
//#include "UARTService.h"
#include <string>

#include "rgb_led.h"
#include "sinusoid.h"
#include "light_show.h"

#include "utility.h"

#include "macros.h"
#include "config.h"
#include "typedef.h"


Serial pc(USBTX, USBRX); // tx, rx

Rgb strip(RED_PIN, GREEN_PIN, BLUE_PIN);

//UARTService *uartServicePtr;
const static char     DEVICE_NAME[] = "Bathroom";
static const uint16_t uuid16_list[] = {ButtonService::BUTTON_SERVICE_UUID};

uint8_t motionState = 0;
ButtonService *buttonServicePtr;


InterruptIn motion(MOTION_PIN);

BLEDevice  ble;

/** Reconnect if bluetooth disconnects **/
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params);

/** chill for 10 seconds for FIR sensor calibration **/
void calibrate();

/** Light weight interrupt handler **/
void motionIRQ();


int main()
{
    DEBUG("Start Main.\r\n");
    strip.init();
    strip.channel_check();
    strip.quiet();
    
//    Sinusoid s(0.0, 1.0);
//    for (float ff;; ff+=0.00005)
//        strip.write(RED, s.get_y(ff));
        
    LightShow show_obj(&strip);  /* object that runs the light show */
 
#define BLE       
#ifdef BLE

    //calibrate();

    ble.init();
    ble.gap().onDisconnection(disconnectionCallback);

    ButtonService buttonService(ble, false /* initial value for button pressed */);
    buttonServicePtr = &buttonService;

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
    ble.gap().startAdvertising();



    while(1) {
#ifdef MKIT
        motion.rise(&motionIRQ);
        if (motionState) {
            pc.printf("Motion detected.\r\n");
            buttonServicePtr->updateButtonState(motionState);
            show_obj.show();
            motionState = 0;
            buttonServicePtr->updateButtonState(motionState);
            strip.quiet();
        }
#elif defined NRFDK
        motion.fall(&strip.show());
#endif

        ble.waitForEvent();
    }
#endif//BLE
} // END main()


void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

void motionIRQ()
{
    motionState = 1;
}

void calibrate()
{

    //give the sensor some time to calibrate
    pc.printf("calibrating sensor\n\r");
    for(int i = 0; i < CALIBRATION_TIME; i++) {
        pc.printf(".");
        identify(CALIBRATION_TIME, strip);
        wait(.5);
    }
    DEBUG(" done\n\r");
    strip.quiet();

    DEBUG("SENSOR ACTIVE\n\r");
    wait(0.05);
}



