/*LED driver library for an "organic" light show, a composition of sine waves.
*
* by Nate Argetsinger
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions: Buy me a beer.
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/


#ifndef LIGHT_SHOW_H
#define LIGHT_SHOW_H

#include "macros.h"
#include "config.h"
#include "utility.h"

#include "rgb_led.h"
#include "sinusoid.h"

extern Serial pc;

const float HYSTERESIS_QUANTITY = PI*2;
const float INCREMENT = 0.00628f * 2;

class LightShow
{
public:
    LightShow(Rgb*);
    
    /* randomize parameters of the 3 sine waves */
    void randomize_params();
    
    /* Displays light show.
    *  The light show is a composition of 3 sine waves for 3 channel LEDs
    **/
    void show();
    
    /** sanity check for debugging **/
    void simple_show();
    
private:
    Rgb* strip;
    Sinusoid sine_waves[3];

    // get some randomness
    Timer t;

    static const float HYSTERESIS_QUANTITY = PI/4;

    float time; // phase
    uint8_t finished; // bit mask for smooth fade out
    float hysteresis;
    float rgb_c[3];

    void update_rgb();
};

#endif