#include "utility.h"
#include "macros.h"


/** random seed for unique identification **/
unsigned long seed = 2345;

unsigned int hash(unsigned int x)
{
    x = ((x >> 16) ^ x) * 0x45d9f3b;
    x = ((x >> 16) ^ x) * 0x45d9f3b;
    x = ((x >> 16) ^ x);
    seed*=2;
    seed+=17;
    return x%100;
}


void identify(unsigned int m, Rgb& strip)
{
    DEBUG("IDENTIFYING as: ");
    unsigned int hashable;
    float write_me;

    int r, g, b;

    hashable = hash(m + seed);
    write_me = hashable/100.0;
    r = hashable >= 50;
    strip.write(RED, r);

    hashable = hash(m + seed);
    write_me = hashable/100.0;
    g = hashable >= 50;
    strip.write(GREEN, g);

    hashable = hash(m + seed);
    write_me = hashable/100.0;
    b = hashable >= 50;
    strip.write(BLUE, b);

//    char* STR;
//    sprintf(STR, "r, g, b: %f\t\r\n", write_me);
//    DEBUG(STR);
    DEBUG("%d%d%d\r\n",r,g,b);
}
