/* LED driver encapsulation */
#ifndef RGB_LED_H
#define RGB_LED_H

#include "mbed.h"


enum channel { RED, GREEN, BLUE };

class Rgb
{
public:
    /** Declare a 3-channel LED interface **/
    Rgb(PinName r, PinName g, PinName b);
    
    void init();
    
    /* write three channels */
    void write_rgb (float red, float green, float blue);
    
    /** write a single value **/
    void write(int channel, float intensity);

    /* turn off all chanels */
    void quiet();
    


    /** Check all 3 channels for heartbeat **/
    void channel_check();

private:
    PwmOut red;
    PwmOut green;
    PwmOut blue;



    Serial* pc;


    bool mov;




    void randomize_params();
    void update_rgb_values ();
    
    


};

#endif