#include "light_show.h"


extern InterruptIn motion;

LightShow::LightShow (Rgb* strip):
    strip(strip), hysteresis(HYSTERESIS_QUANTITY)  {    
    // Set RTC time to Wed, 28 Oct 2009 11:35:37
    set_time(1256729737);
    t.start();
}

void LightShow::show()
{
    printf("show\r\n");
    // randomize the delay and scale values
    randomize_params();
    printf("params initialized:\n\r");

    for (time = 0; time < hysteresis || finished != 0x7; time = time + INCREMENT) {
#ifdef MKIT
        bool mov = motion;
#else
        bool mov = !motion;
#endif
        if (mov) {
            hysteresis = time + HYSTERESIS_QUANTITY;
        }

        // update rgb
        update_rgb();
        
        printf("t:%f\t", time);

        if (time > hysteresis) {
            if (rgb_c[0] < 0.01)
                finished |= 0x1;
            if (rgb_c[1] < 0.01)
                finished |= 0x2;
            if (rgb_c[2] < 0.01)
                finished |= 0x4;
        }
    }
}


void LightShow::simple_show()
{
    finished = 0;
    printf("simple_show()\r\n");
    // randomize the delay and scale values
    randomize_params();
    printf("params initialized:\n\r");

    for (time = 0; time < 10*PI; time = time + INCREMENT) {
        printf("t:%f\t", time);

        // update rgb
        update_rgb();
    }
    strip->quiet();
}

void LightShow::update_rgb()
{
//    printf("\n\rupdate_rgb()\n\r");
    for (int i = 0; i < 3; i++) {
        if (finished & (0x1 << i) ) {
            printf("FINISHED\t");
            strip->write(i, 0.0f);
        } else {
            strip->write(i, rgb_c[i] = sine_waves[i].get_y(time));
            printf("%f\t", rgb_c[i]);
        }
    }
    printf("\n\r");
}



void LightShow::randomize_params()
{
    float rand_seed = t.read();
    pc.printf("float: %f\n\r", rand_seed);
    
    int rand_int = (int) t.read() * 7919;
    pc.printf("int: %d\n\r", rand_int);

    srand(rand_int);
    pc.printf("A random %d\r\n", rand() );

    // generate random values time 0.0 - 1.0
    for (int j = 0; j < 3; j++) {
        float freq = (float) (rand()&0xff) / 0xff;
        sine_waves[j].set_frequency(freq*PI + HPI);
        printf("freq: %f\t", freq);
        //srand(bitmask*j % 17 + 7);
        float wait = (float) (rand()&0xff) / 0xff;
        printf("wait_time: %f\n\r", wait);
        sine_waves[j].set_wait_time(wait);
    }
    finished = 0x0;
    printf("Params Initialized\r\n");
}

#ifdef NO
void show_params()
    pc.printf("WAIT:\t%f\t%f\t%f\n\r", WAIT[0], WAIT[1], WAIT[2]);
    pc.printf("SCALE:\t%f\t%f\t%f\n\r", SCALE[0], SCALE[1], SCALE[2]);
#endif