/* Sine objects for use in light_show.h library */
#ifndef SINUSOID_H
#define SINUSOID_H

const float HPI = 1.571;
const float PI = 3.1416;

class Sinusoid {
public:

/** Get value of Sinusoid
*   Returns a float between 0 and 1
*     - This value is zero if time is < wait
**/
    float get_y(float);
    
    /** constructors **/
    Sinusoid():wait(0), frequency(1){}
    Sinusoid(float wait, float frequency);
    
    /** set sine wave frequency **/
    void set_frequency(float f) {frequency = f;}
    
    /** set wave stall time **/
    void set_wait_time(float w) {wait = w;}
private:

    
    float wait; // before this y is zero
    float frequency;
    
    
};

#endif