#include "rgb_led.h"

Rgb::Rgb(PinName r, PinName g, PinName b):
    red(r), green(g), blue(b) {}

void Rgb::init()
{
    red.period(0.001f);
    green.period(0.001f);
    blue.period(0.001f);
}

void Rgb::write(int channel, float intensity)
{
    switch (channel) {
        case RED:
            red.write(intensity);
            break;
        case GREEN:
            green.write(intensity);
            break;
        case BLUE:
            blue.write(intensity);
            break;
    }
}





void Rgb::write_rgb (float r, float g, float b)
{
    red.write(r);
    green.write(g);
    blue.write(b);
}

//public:



void Rgb::quiet()
{
    red.write(0);
    green.write(0);
    blue.write(0);
    printf("zero_out()\r\n");
}

void Rgb::channel_check()
{
        write_rgb(1, 0, 0);
        wait(.1f);
        write_rgb(0, 1, 0);
        wait(.1f);
        write_rgb(0, 0, 1);
        wait(.1f);
        write_rgb(1, 1, 0);
        wait(.1f);
        write_rgb(1, 0, 1);
        wait(.1f);
        write_rgb(0, 1, 1);
        wait(.1f);
        write_rgb(1, 1, 1);
}