#include "mbed.h"

/* to test if code loaded properly
 */
DigitalOut myled(LED2);

// to power the rf module 
DigitalOut power(p30);
DigitalOut powerStatus(LED1);

/* for time division multiplexing.
 * when an rf tx requires to send signals,
 * it request the other own operating at the same
 * freqeuncy to shut itself down. The other module also
 * follows the same behavioural code!
 */
InterruptIn inRequest(p5);
DigitalOut outRequest(p6);


Serial tx(p9, p10); 
Serial pc(USBTX, USBRX);

// turn RF tx off
void turnOffRF() { 
    power = 0;
    powerStatus = 0;
}

// turn RF tx on
void turnOnRF() {
    power = 1;
    powerStatus = 1;
}

// send a request to the other RF tx to kindly shut down
void sendRequest() {
    outRequest = 0;
    wait(0.1);
    outRequest = 1;
}

int main() 
{
    power = 0; // power to the RF tx
    powerStatus = 0; // power status of the RF tx
    myled = 1;
    char msg[10];

    tx.baud(2400);
    
    /* turn RF tx off when requested by the other tx
     */
    inRequest.rise(turnOffRF);
    
    turnOffRF();
    
    /* read messages from the serial port of the computer
     * and broadcast them
     */
    while (1) { 
        while (pc.readable()) {
            if (power == 0) {
                sendRequest(); // send request to the other RF tx to shut itself down.
                turnOnRF();
            }
            msg[0] = pc.getc();
            tx.putc(msg[0]);
            pc.putc(msg[0]);
        }
       
    }
}
