#include "mbed.h"
#include "Robo.h"


// robot object
Robo roger(p20, p19, p18,
           p21, p22, p23,
           p24, p25, p27, p28, p29, p30);

DigitalOut myled(LED2); 
DigitalOut left(LED3);  // status left LED 
DigitalOut right(LED4); // status right LED

// a buzzer when a life decreses
DigitalOut buzzer(p7);

//the rf receiver Serial object
Serial rx(p9, p10);

//a rise on this pin reduces a life of the robot
InterruptIn heart(p6);

/* a wrapper function for roger.devLives
 * which can be passed as argument to some other funtion
 */
void decRoboLives() {
    roger.decLives();
    buzzer = 0;
 }

int main() {
    char command = 'S';
    rx.baud(2400);
    myled = 1; // test led. test: program loaded successfully
    heart.rise(decRoboLives);

/* main while loop 
 * 1. wait for instructions
 * 1. read instruction
 * 2. do the required action
 * 3. empty the rx object by reading further
 * 4. go to 1
 *  we introduced redundancy in sending the instructions so as to make
 * sure they really end up being received by the robots. that's the raison d'etre
 * for step 3.
 */
    while(1) {
        if (rx.readable()) {
            command = rx.getc();
            switch(command) {
                case 'L' :
                    left = 1;
                    right = 0;
                    roger.goLeft();
                    break;
                case 'R':
                    right = 1;
                    left = 0;
                    roger.moveRight();
                    break;
                case 'M':
                    roger.goAhead();
                    break;
                case 'B':
                    roger.moveBack();
                    break;
                case 'S':
                    roger.stop();
                    break;
                case 'D':
                    roger.printlcd("Hi");
                    wait(1);
                    roger.goLeft();
                    roger.moveRight();
                    roger.goLeft();
                    roger.moveRight();
                    roger.goAhead();
                    wait(1);
                    roger.moveBack();
                    wait(1);
                    roger.stop();
                default:
                    roger.printlcd("Waiting...      ");
                    break;
             
            }
            while (rx.readable())
                command = rx.getc();
        }
    }
 }
