#ifndef __ROBO_H
#define __ROBO_H

#include "Motor.h"
#include "mbed.h"
#include "TextLCD.h"

// intial lives each robot has
const int max_lives = 5;

/* for storing the motors' state, e.g. the robot is moving forward
 * and it receives a request to go left. After it has turned left
 * it must keep moving forward. So we use this structure to backup and restore
 * motors' state.
 */
struct rState {
    mState lm; // pin states of the left motor
    mState rm; // pin states of the right motor
};

/* main Robo Class definition 
 */
class Robo {
    int lives;
    Motor lmotor;
    Motor rmotor;
    TextLCD lcd;
 public :
    Robo(PinName l_en, PinName l_fwd, PinName l_rev, // left motor's enable, forward, and reverse
         PinName r_en, PinName r_fwd, PinName r_rev, // right motor's enable, forward and reverse
         PinName rs, PinName en, PinName d4, PinName d5, // pins for LCD rs, en , d4-d7
         PinName d6, PinName d7);
    void init();    // for initialization of the robot
    void printlcd(char *); // print a message on the robot's lcd
    void updateLivesLCD(); // update the lives count
    void goLeft();  
    void moveRight();
    void stop();
    void goAhead();
    void moveBack();
    int getLives(); // get the number of lives left
    void decLives(); // decrease the number of lives
    rState getState(); // get the state of the robot
    void setState(rState); // set the state of the robot
        
};



#endif