#include "Robo.h"
extern DigitalOut buzzer;

/* implementation of the Robo contructor */
Robo::Robo(PinName l_en, PinName l_fwd, PinName l_rev,
         PinName r_en, PinName r_fwd, PinName r_rev,
         PinName rs, PinName en, PinName d4, PinName d5, 
         PinName d6, PinName d7):
         lmotor(l_en, l_fwd, l_rev), rmotor(r_en, r_fwd, r_rev),
         lcd(rs, en, d4, d5, d6, d7)
{
    lives = max_lives;
    init();
}

/* I changed the cls function in the textLCD library
 * to make it clear only the first row
 */
void Robo::printlcd(char *msg) // printf msg to the first row of LCD
{
    lcd.cls();  
    lcd.printf(msg);
}
void Robo::init() // print the initial msg on the LCD
{
    buzzer = 1;
    lcd.cls_all();
    updateLivesLCD();
    for (int i = 0; i < 2; i++) {
        printlcd("Roger Here!");
        wait(1);
        buzzer = 0;
        printlcd("            ");
        wait(1);
        
    }
    printlcd("Roger Here!");
    
}

/* I believe the following functions are pretty straight forward to 
 * understand
 */

void Robo::goLeft() 
{
    rState temp = this->getState(); // store the current state
    lcd.cls();
    lcd.printf("Going Left!    ");
    lmotor.direct(0);   // stop the left motor
    rmotor.direct(1);   // start the right motor
    wait(1);
    this->setState(temp);   // restore original state
    
}

void Robo::moveRight() 
{
    lcd.cls();
    rState temp = this->getState();
    lcd.printf("Turning Right! ");
    rmotor.direct(0);
    lmotor.direct(1);
    wait(1);
    this->setState(temp);
}

void Robo::stop() 
{
    lcd.cls();
    rmotor.direct(0); // stop motor left
    lmotor.direct(0); // stop motor right
    lcd.printf("Stopped!       ");
}

void Robo::goAhead() 
{
    lcd.cls();
    lcd.locate(0, 0);
    rmotor.direct(1);
    lmotor.direct(1);
    lcd.printf("Moving Forward!");
}

void Robo::moveBack()
{
    lcd.cls();
    rmotor.direct(-1);
    lmotor.direct(-1);
    lcd.printf("Going Back     ");
}

int Robo::getLives()
{
    return lives;
}

// update LCD with the current value of the variable lives
void Robo::updateLivesLCD() { 
    lcd.locate(0, 1);
    lcd.printf("lives : %d", lives);
    lcd.locate(0, 0);
}

void Robo::decLives()
{
    lives--;
    printlcd("oops!!         ");
    updateLivesLCD();
    if (lives == 0) {
        stop();
        int i = 0;
    /* if all lives have been exhausted say goodbye to the world 
     * and rest in a peaceful forever loop
     */
        while (++i) {
            printlcd("GoodBye!!       ");
            wait(0.5);
            printlcd("           ");
            wait(0.5);
            if (i < 4)
                buzzer = 1;
            wait(1);
            buzzer = 0;
        }
    }
    buzzer = 1;
    wait(1);
    buzzer = 0;
    wait(2);
}

rState Robo::getState()
{
    mState lm = lmotor.getState();
    mState rm = rmotor.getState();
    rState temp = {lm, rm }; // return a struct var containing the
    return temp;
}

void Robo::setState(rState roboState) 
{
    lmotor.setState(roboState.lm);
    rmotor.setState(roboState.rm);
}