/* mbed simple H-bridge motor controller
 * Copyright (c) 2007-2010, sford, http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "Motor.h"

#include "mbed.h"

Motor::Motor(PinName en, PinName fwd, PinName rev):
        _en(en), _fwd(fwd), _rev(rev) {

    // Set initial condition for the enable pin
    _en = 0;
    
    // Initial condition of output enables
    _fwd = 0;
    _rev = 0;
}

// direct the motor in a specific direction or stop it
void Motor::direct(int dir) {
    _fwd = (dir > 0);
    _rev = (dir < 0);
    _en = !(dir == 0);
}

/* emulate pwm for a specified time interval */
void Motor::speed(float timeval, float speed) {
    float wait_time = 1/(speed * 10);
    for (int i = 0; i < timeval; i += 0.1 ) {
        _en = 0;
        wait(wait_time/2);
        _en = 1;
        wait(wait_time);
    }

}

mState Motor::getState()
{
    mState temp = { _en, _fwd, _rev };
    return temp;
}

void Motor::setState(mState pinState) 
{
    _en = pinState.en;
    _fwd = pinState.fwd;
    _rev = pinState.rev;
}

