#include "mbed.h"
#include "rtos.h"


DigitalOut led1(LED1);
DigitalOut led2(LED2);

InterruptIn sw2(PTD4);
uint32_t button_pressed;
RawSerial pc(USBTX,USBRX);

Thread *thread2;
Thread *thread3;

char ch;
void sw2_press(void)
{
    thread2->signal_set(0x1);
}

void RX_callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    while(pc.readable())
    {
        ch=pc.getc();
    }
    led2 = !led2;
    thread3->signal_set(0x1);
}
void led_thread(void const *argument)
{
    while (true) {
        led1 = !led1;
        Thread::wait(1000);
    }
}

void button_thread(void const *argument)
{
    while (true) {
        Thread::signal_wait(0x1);
        button_pressed++;
    }
}

void Serial_thread(void const *argument)
{
    while (true) {
        Thread::signal_wait(0x1);
        pc.putc(ch);
    }
}

int main()
{
    Thread thread(led_thread);
    thread2 = new Thread(button_thread);
    thread3 = new Thread(Serial_thread);

    button_pressed = 0;
    sw2.fall(&sw2_press);
    pc.attach(&RX_callback,Serial::RxIrq);
    while (true) {
        Thread::wait(5000);
        //pc.printf("SW2 was pressed (last 5 seconds): %d \n", button_pressed);
        //fflush(stdout);
        button_pressed = 0;
    }
}
