#include "mbed.h"
#include "USBMouse.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

USBMouse mouse;

int main() {
    int x, y,z;
    
    
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    while (1) {
        
        x =1.0f- abs(10*acc.getAccX());
        y = 1.0f- abs(10*acc.getAccY());
        z = 1.0f-abs(10*acc.getAccZ());
        
        mouse.move(x, y);
        wait(0.001);
    }
}