#include "mbed.h"
#include "USBKeyboard.h"
#include "tsi_sensor.h"
 
//LED1: NUM_LOCK
//LED2: CAPS_LOCK
//LED3: SCROLL_LOCK
BusOut leds(LED1, LED2, LED3);
 
//USBKeyboard
USBKeyboard keyboard;

#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif
 
int main(void) 
{
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    while (1) 
    {
        if(tsi.readPercentage() > 0.5)
        {
               keyboard.printf("Gopalakrishnan.N\r\n");
               keyboard.printf("n.gopalkrishnan@ves.ac.in\r\n");
               keyboard.keyCode('s', KEY_CTRL);
               wait(1);
              leds = keyboard.lockStatus();
        }
    }
}