
// PIR Motion Sensor Alarm + ESP8622 WiFi Module + FRDM-k64f
//PIR sensor can detect change on its surrounding by measuring the change of infra red
// Then will send high=1 to the FRDM-k64f to flash the LED, Run the Buzzer,
//Send information through UART serial Port to Tera Term and display how many motion been
//detected,also will send information to Thingspeak IoT website using WiFi connection 



#include "mbed.h"
#include "ESP8266.h"

#define APIKEY YTDILMQL53ASDCJ4

Serial pc(USBTX,USBRX);
DigitalOut Buzzer(D10); // output
PwmOut LED(D13); // flashing the led
DigitalIn inputPin(D2); // pir senor input
DigitalOut redled(LED1);
ESP8266 wifi(PTE0, PTE1, 115200); // baud rate for wifi
char snd[255],rcv[1000];

#define IP "184.106.153.149" // thingspeak.com IP Address

int val = 0; // value to holed the high/low info from pir from pin D2
int cnt = 0; // counter for motion
//String thingtweetAPIKey = "TTEVLP931ODJ5GMT";

/************ WiFi INTIALIZATION *********/

void wifi_initialize(void);
void wifi_send(void);

int main () {
    
pc.baud(9600);   
pc.printf("SET mode to AP\r\n");
wifi.SetMode(1);    // set ESP mode to 1
wifi.RcvReply(rcv, 1000);    //receive a response from ESP
pc.printf("%s",rcv);    //Print the response onscreen
pc.printf("Conneting to AP\r\n");
wifi.Join("VESCAMPUS", "1234@abcd");     // Your wifi username & Password 
wifi.RcvReply(rcv, 1000);    //receive a response from ESP
pc.printf("%s", rcv);    //Print the response onscreen
wait(8);     //waits for response from ESP
pc.printf("Getting IP\r\n");    //get IP addresss from the connected AP
wifi.GetIP(rcv);    //receive an IP address from the AP
pc.printf("%s", rcv);

    
 wait(5); // Delay 5 sec to give the pir time to get snapshut of the surrounding

 pc.printf("Initializing WiFi\r\n");
 //wifi_initialize();
    while (1) {
       
   val = inputPin.read();
   
   if (val==0) {   
    cnt++;
   pc.printf(" The Sensor is ON And I Detected = %i Till NOW\r\n",cnt);
   pc.printf("PLEASE STAY AWAY\r\n");
    pc.printf("Sending WiFi information\n\r");
    wifi_send();
    redled=1; // when the motion detected turn of the on board red led
    LED.period(2.0f); // 2 seconds period
    wait(2.0f);
    LED.pulsewidth(.02);    // 2 mseconds pulse (on)
    redled=1;
    Buzzer = 1;
   wait(1.5f);
          }
    else {
         
    pc.printf(" The Sensor is OFF \r\n");
        LED = 0;
         Buzzer =0;
        redled=0; // turn the on board red led on
          wait(1.5f);
         }
        }
    }

void wifi_send(void){
   
   strcpy(snd,"AT+CIPMODE=0");//Setting WiFi into MultiChannel mode
  wifi.SendCMD(snd);
  pc.printf(snd);
  wifi.RcvReply(rcv, 3000);
  pc.printf("%s", rcv);
  
  //WIFI updates the Status to Thingspeak servers//
  strcpy(snd,"AT+CIPMUX=1");//Setting WiFi into MultiChannel mode
  wifi.SendCMD(snd);
  pc.printf(snd);
  wifi.RcvReply(rcv, 3000);
  pc.printf("%s", rcv);
  
  
  sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80",IP); //Initiate connection with THINGSPEAK server 
  wifi.SendCMD(snd);
  pc.printf(snd);
  wifi.RcvReply(rcv, 3000);
  pc.printf("%s", rcv);
 
  strcpy(snd,"AT+CIPSEND=4,47");    //Send Number of open connections,Characters to send 
  wifi.SendCMD(snd);
  pc.printf(snd);
  wifi.RcvReply(rcv, 3000);
  pc.printf("%s", rcv);
  
    
  sprintf(snd,"GET /update?key=YTDILMQL53ASDCJ4&field1=%2.2f\r\n",1.0); //Post values to thingspeak
  pc.printf("%s",snd);
  wifi.SendCMD(snd);
  
  wifi.RcvReply(rcv, 3000);
  pc.printf("%s", rcv);
  
  wifi.SendCMD("AT+CIPCLOSE"); //Close the connection to server
  wifi.RcvReply(rcv, 3000);
  pc.printf("%s", rcv);
}

