#include "mbed.h"

Ticker Read_Port;                       //Timer Polling

DigitalOut Reset(PTC12);                //ptc12 reset
Serial Comm(USBTX, USBRX);              

#define RX_BUFF_SIZE  64

int rx_write_ptr=0;
int rx_read_ptr=0;
int RX_buff[RX_BUFF_SIZE];

int Data_avl;
int Port_Data;
int Port_Data_prev=0;
int Time_cntr=0;


unsigned int ON_period;
unsigned int OFF_period;
unsigned int Capturestate=0;



void Serial_Read_callback()
{
    RX_buff[rx_write_ptr++]=Comm.getc();
    if(rx_write_ptr >= RX_BUFF_SIZE)
        rx_write_ptr=0;
    
}

int Serial_Read()
{
    int temp;
    
    temp=RX_buff[rx_read_ptr++];
    if(rx_read_ptr >= RX_BUFF_SIZE)
        rx_read_ptr=0;
    return temp;
}

int Serial_Available()
{
    if(rx_read_ptr != rx_write_ptr)
        return 1;
    else
        return 0;
}

void Read_Port_callback()
{
    Port_Data= PTC->PDIR & 0xFF;
    if((Port_Data ^ Port_Data_prev) != 0)
    { 
        Data_avl=1;
        Port_Data_prev=Port_Data;
    }
    Time_cntr++;    
}

static void Input_Capture_ISR(void)
{
    TPM0->STATUS |= TPM_STATUS_CH0F_MASK;
    if(Capturestate == 0) //Rising Edge start the capture
    {
        OFF_period = TPM0->CONTROLS[0].CnV;
        TPM0->CNT = 0;//Clear the counter
        TPM0->CONTROLS[0].CnSC &= ~(TPM_CnSC_ELSA_MASK | TPM_CnSC_ELSB_MASK);
        TPM0->CONTROLS[0].CnSC |= TPM_CnSC_ELSB_MASK;
        TPM0->CONTROLS[0].CnSC &= ~TPM_CnSC_ELSA_MASK;
        Capturestate =1;//Wait for the Falling Edge
        Data_avl=1;
    }
    else if(Capturestate == 1)
    {
        ON_period = TPM0->CONTROLS[0].CnV;
        TPM0->CNT = 0;//Clear the counter
        TPM0->CONTROLS[0].CnSC &= ~(TPM_CnSC_ELSA_MASK | TPM_CnSC_ELSB_MASK);
        TPM0->CONTROLS[0].CnSC |= TPM_CnSC_ELSA_MASK;
        TPM0->CONTROLS[0].CnSC &= ~TPM_CnSC_ELSB_MASK;
        Capturestate =0;//Wait for the Falling Edge
        Data_avl=1;
    }
    
}

void Port_Capture_Init(void)
{
    unsigned int i;
    for(i=0;i<8;i++)//Make all the pins digital I/O
    {
        PORTC->PCR[i] |= PORT_PCR_MUX(1)| PORT_PCR_PE_MASK  ;
        PTC->PDDR   &= ~(GPIO_PDDR_PDD(i));//Make all the Pins Input
    }
}
void Input_Capture_Init(void)
{
    SIM->SCGC5 |= SIM_SCGC5_PORTC_MASK;
    PORTC->PCR[1] |= PORT_PCR_MUX(4)| PORT_PCR_PE_MASK  ;
    SIM->SOPT2 |= SIM_SOPT2_TPMSRC(1);   //Enable the Timer Clock to MCGFLLCLK
    //SIM->SOPT2 &= ~(SIM_SOPT2_PLLFLLSEL_MASK);//Enable MCGFLLCLK 
    SIM->SCGC6 |= SIM_SCGC6_TPM0_MASK;   // Clock TPM0
    
    
    TPM0->MOD =0xFFFF;//Maximum Value of MOD
    TPM0->CNT = 0;//Clear the counter
    
    
    TPM0->SC |= TPM_SC_TOF_MASK | TPM_SC_CMOD(1) |TPM_SC_PS(0);//Incrmenets on each clock and No clock divide
    //Channel 0 is used for Input Capture and INterrupt is Enabled 
    TPM0->CONTROLS[0].CnSC |= TPM_CnSC_CHF_MASK | TPM_CnSC_CHIE_MASK | TPM_CnSC_ELSA_MASK ;//First is the rising edge
    TPM0->CONTROLS[0].CnSC &= ~(TPM_CnSC_MSB_MASK | TPM_CnSC_MSA_MASK | TPM_CnSC_ELSB_MASK);
    
    //Interrupt is Enabled
    NVIC_SetVector(TPM0_IRQn, (uint32_t)Input_Capture_ISR);
    NVIC_EnableIRQ(TPM0_IRQn);
}

void Input_Capture_Disable()
{
    NVIC_DisableIRQ(TPM0_IRQn);
}


int main()
{
    int ch;
    int state=0;
    int cmd=0;;
    int paramval[3][3];
    int paramstate=0;
    int paramdigcnt=0;
    int new_frame=0;
    int run_debug=0;
    
    float scan_time;
    int   value_cnt=0;
    int   command_mode=0;
    
    Comm.baud(115200);
    Comm.attach(&Serial_Read_callback);
    
    while(true)
    {
        if(Serial_Available())
        {
            ch=Serial_Read();
            Comm.printf("%c",ch,state);
            switch (state)
            {
                case 0:     if(ch == '<')
                            {
                                state++;
                                paramstate=0;;
                            }    
                                
                            break;
                            
                case 1:     cmd = ch;
                            state++;
                            break;
                            
                case 2:     if(ch == ',')
                            {
                                paramstate++;
                                paramdigcnt=2;
                            }
                            else if(ch == '>')
                            {
                                state=0;
                                new_frame =1;
                                
                            }
                            else 
                            {
                                paramval[paramstate-1][paramdigcnt--]=ch - '0';
                            }    
                            break;
                
                                
            }//switch
            
            
        }//Serial_available
        
        if(new_frame)
        {
            Comm.printf("\n\rStarted polling Command=%c \n\r",cmd);
            new_frame =0;
            Port_Data_prev=0;
            Time_cntr=0;
            if(cmd == 'P')
            {
                Port_Capture_Init();
                scan_time= (paramval[0][0] +paramval[0][1]* 10 + paramval[0][2] * 100)*0.01;
                Comm.printf("Scan Time %f mS \n\r",scan_time*1000);
                Read_Port.attach(&Read_Port_callback,scan_time);
                Reset=0;
                wait(0.01);
                Reset=1;
                run_debug=1;
                command_mode=1;
            }
            else if(cmd == 'W')
            {
                value_cnt = (paramval[0][0] + paramval[0][1]* 10 + paramval[0][2] * 100);
                Input_Capture_Init();
                run_debug=1;
                command_mode=2;
            }
            else if(cmd == 'X')
            {
                Read_Port.detach();
                Input_Capture_Disable();
                run_debug=0;
            }   
            
        }
        
        if(run_debug)
        {
            
            if(Data_avl)
            {
                if(command_mode == 1)
                {
                    Comm.printf("<%.4X,%.2X>\n\r",Time_cntr,Port_Data);
                    Data_avl=0;
                    Time_cntr=0;
                }
                else if (command_mode == 2 )
                {
                    if(value_cnt-- != 0)
                    {
                        Comm.printf("<%.4X,%.4X,%.4X>\n\r",value_cnt,ON_period,OFF_period);
                        Data_avl=0;
                    }
                    else
                    {
                        Input_Capture_Disable();
                    }
                }
            }
        }
        
    }//while
}
