#include "mbed.h"

enum HW_State{RST,RUN};

DigitalOut Reset(PTD4);
BusIn  Input(PTA12,PTA4,PTA5,PTC8);
DigitalOut SW1(PTA13);
DigitalOut SW2(PTD5);

Serial pc(USBTX,USBRX);

enum HW_State FRDM_State;
int Program_State[3];
unsigned char command;
 char curr_state;
 char prev_state;
 char inc_btn_state;
 char dec_btn_state;
 char counter;
 
 void Check_error(char led_state,char btn_state)
{
    if(led_state == btn_state) //At Start or at Roll over
    {
        Program_State[0] = 0;
    }
    else 
    {
        Program_State[0] = -1;
    }
}

void Inc_Btn()
{
    SW1=1;
    SW1=0;
    wait_ms(rand()%5);
    SW1=1;
    wait_ms(rand()%5);
    SW1=0;
    wait_ms(rand()%10);
    SW1=1;
    wait_ms(rand()%5);
    SW1=0;
    wait_ms(50);
    wait_ms(rand()%100);
    SW1=1;
    
}
void Dec_Btn()
{
    SW1=1;
    SW1=0;
    wait_ms(rand()%5);
    SW1=1;
    wait_ms(rand()%5);
    SW1=0;
    wait_ms(rand()%10);
    SW1=1;
    wait_ms(rand()%5);
    SW1=0;
    wait_ms(50);
    wait_ms(rand()%100);
    SW1=1;
    
}

int main() {
    Reset = 1;//Need to find what is the reset Methdology
    FRDM_State=RST;
    prev_state =0;
    Input.mode(PullNone);
    SW1=1;
    SW2=1;
    inc_btn_state=0;
    while(1) {
        if(pc.readable())
        {
            command=pc.getc();
            switch(command)
            {
                case 's':
                case 'S':  Reset =0;
                           FRDM_State=RUN;
                           
                           break;
                case 'x':
                case 'X':  Reset =1;
                           FRDM_State=RST;
                           break;
                           
                case 'd':
                case 'D': pc.printf("%d,%d\n\r",Program_State[0],Program_State[1]);
                          break;
                          
            }
        }
        if(FRDM_State == RUN)
        {
            for(counter =0; counter <20;counter++)
            {
                 Inc_Btn();
                 if(inc_btn_state <= 15)
                    inc_btn_state++;
                 curr_state=Input & Input.mask();
                 Check_error(curr_state,inc_btn_state);
                 wait(0.2f);
            }
            for(counter =0; counter <20;counter++)
            {
                 Dec_Btn();
                 if(inc_btn_state != 0)
                    inc_btn_state--;
                 curr_state=Input & Input.mask();
                 Check_error(curr_state,inc_btn_state);
                 wait(0.2f);
            }
        }
        
    }
}


