#include "mbed.h"

enum HW_State{RST,RUN};

DigitalOut Reset(PTD4);
BusIn  Input(PTA12,PTA4,PTA5,PTC8);

Serial pc(USBTX,USBRX);

enum HW_State FRDM_State;
int Program_State[3];
unsigned char command;
 char curr_state;
 char prev_state;
 Timer t;
 int timer_ms;
 
 
 void Check_error(char curr_state,char prev_state)
{
    if(((curr_state == 0) && ((prev_state == 0) || (prev_state == 9)) ||((prev_state+1) == curr_state))) //At Start or at Roll over
    {
        Program_State[0] = 0;
    }
    else 
    {
        Program_State[0] = -1;
    }
}


int main() {
    Reset = 1;//Need to find what is the reset Methdology
    FRDM_State=RST;
    prev_state =0;
    Input.mode(PullNone);
    
    while(1) {
        if(pc.readable())
        {
            command=pc.getc();
            switch(command)
            {
                case 's':
                case 'S':  Reset =0;
                           FRDM_State=RUN;
                           t.start();
                           break;
                case 'x':
                case 'X':  Reset =1;
                           FRDM_State=RST;
                           break;
                          
            }
        }
        if(FRDM_State == RUN)
        {
            curr_state=Input & Input.mask();
            if(curr_state != prev_state)
            {
                t.stop();
                timer_ms=t.read_ms();
                t.reset();
                t.start();
                Check_error(curr_state,prev_state);
                prev_state = curr_state;
                if(( timer_ms> 494) && (timer_ms < 505))
                {
                    Program_State[1] = 0;
                }
                else
                {
                    Program_State[1] = -1;
                }
                
                if(curr_state == 0 && prev_state == 9)
                {
                    pc.printf("%d,%d\n\r",Program_State[0],Program_State[1]);
                }
            }
        }
        
    }
}


