/**
 * Author: Narasimma DLN
 * Email: narasimma23@gmail.com
 */
 
#include "mbed.h"

#define     FLASH_START_ADDR    0x08000000
#define     FLASH_SIZE_ADDR     0x1FFFF7CC
#define     FLASH_SIZE          (256 * 1024) 
#define     FLASH_SECTOR_SIZE   (2 * FLASH_PAGE_SIZE)
#define     FLASH_SECTORS       64

/*
#define     FLASH_SECTOR_0      0x08000000
#define     FLASH_SECTOR_1      0x08001000
#define     FLASH_SECTOR_2      0x08002000
#define     FLASH_SECTOR_3      0x08003000
#define     FLASH_SECTOR_4      0x08004000
#define     FLASH_SECTOR_5      0x08005000
#define     FLASH_SECTOR_6      0x08006000
#define     FLASH_SECTOR_7      0x08007000
#define     FLASH_SECTOR_8      0x08008000
#define     FLASH_SECTOR_9      0x08009000
#define     FLASH_SECTOR_10     0x0800A000
#define     FLASH_SECTOR_11     0x0800B000
#define     FLASH_SECTOR_12     0x0800C000
#define     FLASH_SECTOR_13     0x0800D000
#define     FLASH_SECTOR_14     0x0800E000
#define     FLASH_SECTOR_15     0x0800F000
#define     FLASH_SECTOR_16     0x08010000
#define     FLASH_SECTOR_17     0x08011000
#define     FLASH_SECTOR_18     0x08012000
#define     FLASH_SECTOR_19     0x08013000
#define     FLASH_SECTOR_20     0x08014000
#define     FLASH_SECTOR_21     0x08015000
#define     FLASH_SECTOR_22     0x08016000
#define     FLASH_SECTOR_23     0x08017000
#define     FLASH_SECTOR_24     0x08018000
#define     FLASH_SECTOR_25     0x08019000
#define     FLASH_SECTOR_26     0x0801A000
#define     FLASH_SECTOR_27     0x0801B000
#define     FLASH_SECTOR_28     0x0801C000
#define     FLASH_SECTOR_29     0x0801D000
#define     FLASH_SECTOR_30     0x0801E000
#define     FLASH_SECTOR_31     0x0801F000
#define     FLASH_SECTOR_32     0x08020000
#define     FLASH_SECTOR_33     0x08021000
#define     FLASH_SECTOR_34     0x08022000
#define     FLASH_SECTOR_35     0x08023000
#define     FLASH_SECTOR_36     0x08024000
#define     FLASH_SECTOR_37     0x08025000
#define     FLASH_SECTOR_38     0x08026000
#define     FLASH_SECTOR_39     0x08027000
#define     FLASH_SECTOR_40     0x08028000
#define     FLASH_SECTOR_41     0x08029000
#define     FLASH_SECTOR_42     0x0802A000
#define     FLASH_SECTOR_43     0x0802B000
#define     FLASH_SECTOR_44     0x0802C000
#define     FLASH_SECTOR_45     0x0802D000
#define     FLASH_SECTOR_46     0x0802E000
#define     FLASH_SECTOR_47     0x0802F000
#define     FLASH_SECTOR_48     0x08030000
#define     FLASH_SECTOR_49     0x08031000
#define     FLASH_SECTOR_50     0x08032000
#define     FLASH_SECTOR_51     0x08033000
#define     FLASH_SECTOR_52     0x08034000
#define     FLASH_SECTOR_53     0x08035000
#define     FLASH_SECTOR_54     0x08036000
#define     FLASH_SECTOR_55     0x08037000
#define     FLASH_SECTOR_56     0x08038000
#define     FLASH_SECTOR_57     0x08039000
#define     FLASH_SECTOR_58     0x0803A000
#define     FLASH_SECTOR_59     0x0803B000
#define     FLASH_SECTOR_60     0x0803C000
#define     FLASH_SECTOR_61     0x0803D000
#define     FLASH_SECTOR_62     0x0803E000
#define     FLASH_SECTOR_63     0x0803F000
*/

/* Return Code */
typedef enum {
    Success = 0,
    WriteProtError,
    ProgrammingError,
}IAPCode;

// Get the flash sectors
void get_flash_sectors(void);

// Get Flash Size
uint32_t get_flash_size(void);

// Get Sector Number
uint8_t get_sector_number(uint32_t _addr);

// Get Sector Size
uint32_t get_sector_size(uint32_t addr);

// Erase a Flash Sector
IAPCode erase_sector(int address);

// Programming Flash Memory
IAPCode program_flash(uint32_t address, uint16_t *data, unsigned int length);