/**
 * Author: Narasimma DLN
 * Email: narasimma23@gmail.com
 */
 
#include "mbed.h"
#include "stm_iap.h"

#define BUFFER_LEN      4096

// Debug Serial Port
RawSerial pc(PB_3, PD_2);
DigitalOut led(PB_12);

static uint8_t recBuf[BUFFER_LEN];
static int recBufLen;
bool startProgram = false;

/* Serial RX IRQ function */
void serial_callback(void)
{    
    if (pc.readable()) {
        //pc.putc(pc.getc());
        recBuf[recBufLen++] = pc.getc();
        
        if (recBufLen == BUFFER_LEN)
            startProgram = true;
    }
}

void processBuffer(void)
{
    IAPCode ret;
    uint32_t addr = 0x08000000;
    
    pc.printf("Processing Buffer...!\r\n");
    
    // Testing Flash Erase
    ret = erase_sector(addr);
    pc.printf("Erasing the Sector: %x, ret: %d\r\n", addr, ret);
    
    // Testing Flash Program
    ret = program_flash(addr, (uint16_t *)recBuf, FLASH_SECTOR_SIZE);
    pc.printf("Flashing done: %d\r\n", ret);
    
    recBufLen = 0;
    startProgram = false;
}

int main(void)
{
    uint8_t *ptr, ret;
    uint32_t addr = FLASH_START_ADDR;
    
    pc.baud(115200);
    pc.printf("NUCLEO_F092RC In-App Programming Test!\r\n");
    pc.attach(&serial_callback, Serial::RxIrq);
    
    pc.printf("FLASH SIZE = %d\r\n", get_flash_size());
    get_flash_sectors();
    
    // Test Reading a byte from Flash
    ptr = (uint8_t *)addr;
    pc.printf("First byte: %x\r\n", ptr[1]);
    
    addr = FLASH_PAGE_SIZE;
    pc.printf("FLASH_PAGE_SIZE: %d\r\n", addr);
    
    // Testing sector_number function and sector_size
    addr = 0x08009000;
    pc.printf("Get Sector No. for addr 0x%08x is: %d and size is: %d\r\n", addr, get_sector_number(addr), get_sector_size(addr));
    
    // Testing Flash Erase
    ret = erase_sector(addr);
    pc.printf("Erase Sector: %d\r\n", ret);
    
    while(1) {
        wait(1);
        led = !led;
        
        pc.printf("Len: %d\r\n", recBufLen);
        
        if (startProgram)
            processBuffer();
    }
}