/*
Modified by COX
version 0.1

Editor     : COX
Date       : 06.03.2013

*
* Update DFRobot source to work on FRDM KL25Z
*
*/

#ifndef LCD4884_h
#define LCD4884_h

#include "mbed.h"

// SPI Interface --- (on arduino Arduino Digital Pin 2,3,4,5,6)
#define SPI_SCK  D2 //Serial Clock(Master Output)
#define SPI_MOSI D3//Master Output,Slave Input
#define LCD_DC   D4 //Data/Command(command active low)
#define SPI_CS   D5//Chip Select,Slave Transmit Enable(active low,Master Output)
#define LCD_RST  D6 //One Reset button
#define LCD_BL   D7 //PWM Backlit control (Arduino DIO Pin 7)


//display mode -- normal / highlight
#define MENU_NORMAL 0
#define MENU_HIGHLIGHT 1
#define OFF 0
#define ON 1
#define LOW 0
#define HIGH 1
#define ONE_US 0.000001
#define LCD_INITIAL_BRIGHTNESS 1

namespace mbed {

class LCD4884
{
    public:
    LCD4884();
    void LCD_init(void);
    void backlight(float dat);
    void LCD_write_byte(unsigned char dat, unsigned char dat_type);
    void LCD_draw_bmp_pixel(unsigned char X,unsigned char Y,unsigned char *map,unsigned char Pix_x,unsigned char Pix_y);
    void LCD_write_string(unsigned char X,unsigned char Y,char *s, char mode);
    void LCD_prop_write_string(unsigned char X,unsigned char Y,char *s, char mode);
    void LCD_write_chinese(unsigned char X, unsigned char Y,unsigned char *c,unsigned char ch_with,unsigned char num,unsigned char line,unsigned char row);
    void LCD_write_string_big ( unsigned char X,unsigned char Y, char *string, char mode );
    void LCD_write_char_big (unsigned char X,unsigned char Y, unsigned char ch, char mode);
    void LCD_write_char(unsigned char c, char mode);
    unsigned char LCD_prop_write_char(unsigned char c, char mode);
    void LCD_set_XY(unsigned char X, unsigned char Y);
    void LCD_clear(void);
    };
}
extern LCD4884 lcd;
              
#endif

