#include "mbed.h"
#include "MFRC522.h"
#define MF_RESET    D8

DigitalOut LedGreen(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);

MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);

int main(void) {
  int data[10];
  pc.printf("starting...\n");

  // Init. RC522 Chip
  RfChip.PCD_Init();

  while (true) {
    LedGreen = 1;

    // Look for new cards
    if(data[0] == 199 && data[1] == 230 &&data[2] == 46 &&data[3] == 0 )
    {
        pc.printf(" admin \n");
    data[0] = 0;
    data[1] = 0;
    data[2] = 0;
    data[3] = 0;
    }
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }

    LedGreen = 0;

    // Print Card UID
    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      data[i] =  RfChip.uid.uidByte[i];
      pc.printf("%d ", data[i]);
        
    }  
    
    //pc.printf("\n\r");
    //pc.printf("\n\r");
    //char data[0];
    //pc.printf("  %X02", data[0]);
    //pc.printf("  %s\n", data[0]);
    
    pc.printf("\n\r");
  }
}
