#include "mbed.h"
#include "EthernetInterface.h"

#define USE_DHCP    0

#define PORT    5000

const char * IP_Addr    = "192.168.11.194";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.11.1";
const char * Target_IP  = "192.168.11.227";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};


Serial pc(USBTX, USBRX);

DigitalOut ledR0(LED_RED);
DigitalOut ledG0(LED_GREEN);
//DigitalOut ledB0(LED_BLUE);

DigitalOut led0(D5);
DigitalOut led1(D6);

DigitalIn PIR(D8);
AnalogIn CDS(A0);

#define PLED_ON      led0 = led1 = 1
#define PLED_OFF     led0 = led1 = 0

int CDS_data;
int PIR_sensor;

int CDS_check()
{
    CDS_data = CDS.read()*1000;
    return CDS_data;
}

int PIR_check()
{
    PIR_sensor = PIR;
    return PIR_sensor;
}

int main() {
    ledR0 = ledG0 = 1;
    PLED_OFF;

    unsigned char flag = 1;
    int csd_int = 2;
    int pir_int0 = 2;
    int pir_int1 = 2;
    int pir_status = 0;
    
    pc.baud(115200);
    wait(0.5f);
    pc.printf("Hello WIZwiki-W7500!\n\r");
    pc.printf("===========================================\n\r");
    
    EthernetInterface eth;
    #if USE_DHCP
    int ret = eth.init(MAC_Addr);
    #else
    int ret = eth.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    #endif
    TCPSocketConnection client;
    
    //eth.link(3000);
    wait(5);
    pc.printf("Connecting......wait 5sec \r\n");
    if (!ret) {
        pc.printf("Initialized, \r\nMAC: %s\r\n", eth.getMACAddress());
        ret = eth.connect();
        if (!ret) {
            pc.printf("IP: %s \r\nMASK: %s \r\nGW: %s\r\n",
                      eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
        } else {
            pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
            exit(0);
        }
    } else {
        pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
        exit(0);
    }
    
    client.connect(Target_IP,5000);
    
    if(client.is_connected() == 1){
        pc.printf("Connected success : %s\r\n", client.get_address());
        client.send("Hello server!\r\n", 15);
        PLED_ON;
        wait(0.2f);
        PLED_OFF;
        wait(0.2f);
        PLED_ON;
        wait(0.2f);
        PLED_OFF;
    }
    else {
        pc.printf("Connected fail : %s\r\n", client.get_address());
        PLED_ON;
        wait(0.4f);
        PLED_OFF;
    }

    while (1) {
        Timer t;
        if(CDS_check() > 600){
            if(csd_int != 0){
                pc.printf("Now is dark.\r\n");
                client.send("Now is dark.\r\n", 14);
                csd_int = 0;
            }
            ledG0 = 0;
            flag = 1;
            while(flag){
                if(PIR_check()){
                    if(pir_int0 != 0){
                        pc.printf("The movement is detected.\r\n");
                        pc.printf("Power LED is turned on.\r\n");
                        client.send("The movement is detected.\r\n", 27);
                        client.send("Power LED is turned on.\r\n", 25);
                        pir_int0 = 0;
                    }
                    t.stop();
                    t.reset();
                    t.start();
                    pir_status = 1;
                    ledR0 = 0;
                    PLED_ON;
                }
                if(pir_status == 0) {
                    flag = 0;
                }
                if(t.read_ms() > 5000 && pir_status == 1){
                    if(pir_int0 != 1){
                        pc.printf("The movement is not detected.\r\n");
                        pc.printf("Power LED is turned off.\r\n");
                        client.send("The movement is not detected.\r\n", 31);
                        client.send("Power LED is turned off.\r\n", 26);
                        pir_int0 = 1;
                    }
                    t.stop();
                    t.reset();
                    pir_status = 0;
                    ledR0 = 1;
                    PLED_OFF;
                    flag = 0;
                    wait(0.1f);
                }
            }
        }
        else{
            if(csd_int != 1){
                pc.printf("Now is brighter.\r\n");
                client.send("Now is brighter.\r\n", 18);
                csd_int = 1;
            }
            
            ledG0 = 1;
            if(PIR_check()){
                if(pir_int1 != 0){
                    pc.printf("The movement is detected.\r\n");
                    client.send("The movement is detected.\r\n", 27);
                    pir_int1 = 0;
                }
                ledR0 = 0;
            }
            else{
                if(pir_int1 != 1){
                    pc.printf("The movement is not detected.\r\n");
                    client.send("The movement is not detected.\r\n", 31);
                    pir_int1 = 1;
                }
                ledR0 = 1;
            }
        }
    }
}