#include "mbed.h"
#include "EthernetInterface.h"
#include "SNTPClient.h"
#include "SHTx/sht15.hpp"

uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x11, 0x22, 0xab};

Serial pc(USBTX,USBRX);
EthernetInterface eth;
datetime ntptime;
DigitalOut busy(LED1);
SHTx::SHT15 sensor(D2, D3);

struct tm timeinfo;

int main()
{
    pc.baud(115200);
    wait(0.5f);
    pc.printf("Hello WIZwiki-W7500!\n\r");
    pc.printf("===========================================\n\r");
    
    
    eth.init(mac_addr); //Use DHCP
    printf("Check Ethernet Link\r\n");
    while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }
    
    printf("Link up\r\n");
    printf("Getting IP address by DHCP...\r\n");
    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
    printf("Getting time information by using NTP...\r\n");
    
    SNTPClient sntp("time.nist.gov", 40);   // timezone: Korea, Republic of
    sntp.connect();
    if(sntp.getTime(&ntptime) == true)
    {
          printf("%d-%d-%d, %02d:%02d:%02d\r\n", ntptime.yy, ntptime.mo, ntptime.dd, ntptime.hh, ntptime.mm, ntptime.ss);
          printf("Completed Get and Set Time\r\n\r\n");
    }
    else
    {
        while(sntp.getTime(&ntptime) == true)
        {
            break;
        }
    }
    
    sensor.setOTPReload(false);
    sensor.setResolution(true);
    while(1)
    {
        busy = true;
        sensor.update();
        busy = false;
        
        sntp.getTime(&ntptime);
        printf("< The current time : %d-%d-%d, %02d:%02d:%02d >\r\n", ntptime.yy, ntptime.mo, ntptime.dd, ntptime.hh, ntptime.mm, ntptime.ss);
        
        // Temperature in celcius
        sensor.setScale(false);
        pc.printf("Temperature [ %3.2f C ]\r\n", sensor.getTemperature());
        
        // Temperature in fahrenheit
        sensor.setScale(true);
        pc.printf("            [ %3.2f F ]\r\n", sensor.getTemperature());
        
        // Relative Humidity
        pc.printf("Humdity     [ %3.2f %% ]\r\n", sensor.getHumidity());
        
        pc.printf("===========================================\n\r");        
        wait(5);
        
    }
    
}
