#include "mbed.h"
#include "segment.h"
Serial pc1(USBTX,USBRX);

BusOut Seg_num(P5,P6,P7,P8,P9,P10,P11,P12);
BusOut Seg_Sel(P20,P19,P18,P17,P16,P15,P14,P13);


uint8_t SEGMENTS[37] = {
        //*********************************************************
        // 7segment pattern,
        //*********************************************************
        //      seg: g f e  d c b a
        //      bit: 6 5 4  3 2 1 0
        //      --------------------
        0xC0,        // 0         1 0 0  0 0 0 0
        0xF9,        // 1    ./     1 1 1  1 0 0 1
        0xA4,        // 2         0 1 0  0 1 0 0
        0xB0,        // 3         0 1 1  0 0 0 0
        0x99,        // 4         0 0 1  1 0 0 1
        0x92,        // 5         0 0 1  0 0 1 0
        0x82,        // 6         0 0 0  0 0 1 0
        0xD8,        // 7         1 0 1  1 0 0 0
        0x80,        // 8         0 0 0  0 0 0 0
        0x90,        // 9         0 0 1  0 0 0 0
        0x88,        // A         0 0 0  1 0 0 0
        0x83,        // B         0 0 0  0 0 1 1
        0xC6,        // C         1 0 0  0 1 1 0
        0xA1,        // D         0 1 0  0 0 0 1
        0x86,        // E         0 0 0  0 1 1 0
        0x8E,        // F         0 0 0  1 1 1 0
        0xC2,        // G         1 0 0  0 0 1 0
        0x89,        // H         0 0 0  1 0 1 1
        0xCF,        // I         1 0 0  1 1 1 1
        0xE1,        // J         1 1 0  0 0 0 1
        0x8A,        // K         0 0 0  1 0 1 0
        0xC7,        // L         1 0 0  0 1 1 1
        0xEA,        // M         1 1 0  1 0 1 0
        0xAB,        // N         0 1 0  1 0 1 1
        0xA3,        // O         0 1 0  0 0 1 1
        0x8C,        // P         0 0 0  1 1 0 0
        0x98,        // Q         0 0 1  1 0 0 0
        0xCC,        // R         1 0 0  1 1 0 0
        0x96,        // S         0 0 1  0 1 1 0
        0x87,        // T         0 0 0  0 1 1 1
        0xE3,        // U         1 1 0  0 0 1 1
        0xC1,        // V         1 0 0  0 0 0 1
        0xD5,        // W         1 0 1  0 1 0 1
        0x89,        // X         0 0 0  1 0 0 1
        0x91,        // Y         0 0 1  0 0 0 1
        0xB4,        // Z         0 1 1  0 1 0 0
        0xFF         //           1 1 1  1 1 1 1
        };

uint8_t SEGMENT_SEL[9] = {0x00,0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};

void Seg_Drive(int seg, int num, int dot)
{
    Seg_num = 0xff;
    Seg_Sel = SEGMENT_SEL[seg];
    if(dot == 1)
    {
        Seg_num = SEGMENTS[num] & 0x7F;
    }
    else
    {
        Seg_num = SEGMENTS[num];
    }
    wait_ms(1);
}

void Seg_Test_1()
{
    for(int j = 1 ; j <9 ; j++)
    {            
        pc1.printf("SEGMENT_SEL : %x\r\n",SEGMENT_SEL[j]);           
        for(int i = 0; i<10 ; i++)
        {
            Seg_Drive(j,i,1);
            pc1.printf("Seg Num : %d\r\n",i);
            wait(0.05);
        }
    }
    Seg_num = 0xff;
}
void Seg_Test_2()
{
    Seg_num = 0x00;
    Seg_Sel = 0xff;
    wait(0.5);
    Seg_num = 0xff;
    Seg_Sel = 0x00;
    wait(0.5);
}

void Seg_Reset()
{
    Seg_num = 0xff;
    Seg_Sel = 0x00;
}

void display_ymd(char buffer[])
{
    int dot = 0;
    for(int i = 0 ; i <= 7 ; i++)
    {
        if(i == 3)      dot = 1;
        else if(i == 5) dot = 1;
        else if(i == 7) dot = 1;
        else            dot = 0;
        buffer[i] -= 48;
        Seg_Drive(i+1,buffer[i],dot);
    }
    
}

void display_hms(char buffer[])
{
    int dot = 0;
    for(int i = 0 ; i < 6 ; i++)
    {
        if(i == 1)      dot = 1;
        else if(i == 3) dot = 1;
        else if(i == 5) dot = 1;
        else            dot = 0;
        buffer[i] -= 48;
        Seg_Drive(i+2,buffer[i],dot);
    }
}

void display_temp(float temp_val){
    //Seg_Reset();
    int temp_val_int = (int)(temp_val*10);
    char temp_val_arr[5]={0,0,0,36,12};
    
    temp_val_arr[0] = temp_val_int/100;    
    temp_val_arr[1] = (temp_val_int-(temp_val_arr[0]*100))/10;    
    temp_val_arr[2] = temp_val_int-((temp_val_arr[0]*100)+(temp_val_arr[1]*10));
    
    int dot = 0;
    for(int i = 0 ; i < 5 ; i++)
    {
        if(i == 1)      dot = 1;
        else    dot = 0;
        Seg_Drive(i+3,temp_val_arr[i],dot);
    }
}
void display_humi(float humi_val){
    //Seg_Reset();
    int humi_val_int = (int)(humi_val*10);
    char humi_val_arr[5]={0,0,0,36,17};
    
    humi_val_arr[0] = humi_val_int/100;    
    humi_val_arr[1] = (humi_val_int-(humi_val_arr[0]*100))/10;    
    humi_val_arr[2] = humi_val_int-((humi_val_arr[0]*100)+(humi_val_arr[1]*10));
    
    int dot = 0;
    for(int i = 0 ; i < 5 ; i++)
    {
        if(i == 1)      dot = 1;
        else    dot = 0;
        Seg_Drive(i+3,humi_val_arr[i],dot);
    }
}