#include "mbed.h"
#include "segment.h"
#include "EthernetInterface.h"
#include "SNTPClient.h"
#include "SHTx/sht15.hpp"

Serial pc(USBTX,USBRX);
EthernetInterface eth;
datetime ntptime;

InterruptIn SW1(P21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

SHTx::SHT15 sensor(P22, P23);

void SW1_Interrupt();
void SNTP_Connect();
void time_set();
void time_update(char buffer[]);
float update_sht11(uint8_t sensor_sel);

struct tm timeinfo;

uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x11, 0x22, 0xab};
uint8_t display_mode = 0;
uint8_t update_mode = 0;
uint8_t Set_update[3] = {18, 00, 00};   //Hour,Minute,Second
uint8_t SW_toggle = 0;

void SW1_Interrupt(){
    //led2=!led2;
    display_mode = display_mode + 1;
        
    if(display_mode == 4)    display_mode = 0;
    printf("Display Mode : %d\n\r",display_mode);
}

void SNTP_Connect() {
    printf("Getting time information by using NTP...\r\n");
    
    SNTPClient sntp("time.nist.gov", 40);   // timezone: Korea, Republic of
    sntp.connect();
    if(sntp.getTime(&ntptime) == true) {
          printf("%d-%d-%d, %02d:%02d:%02d\r\n", ntptime.yy, ntptime.mo, ntptime.dd, ntptime.hh, ntptime.mm, ntptime.ss);
          printf("Completed Get and Set Time\r\n\r\n");
          led1 = 0;
    }
    else {
        while(sntp.getTime(&ntptime) == true) {
            printf("%d-%d-%d, %02d:%02d:%02d\r\n", ntptime.yy, ntptime.mo, ntptime.dd, ntptime.hh, ntptime.mm, ntptime.ss);
            printf("Completed Get and Set Time\r\n\r\n");
            led1 = 0;
            break;
        }
    }
}
void time_set() {
    timeinfo.tm_mon = ntptime.mo-1;
    timeinfo.tm_mday = ntptime.dd;
    timeinfo.tm_hour = ntptime.hh;
    timeinfo.tm_min = ntptime.mm;
    timeinfo.tm_sec = ntptime.ss;
    timeinfo.tm_year = ntptime.yy-1900;
    time_t t =mktime(&timeinfo);
    set_time(t);
    t = time(NULL);
}

void time_update(char buffer[]) {
    uint8_t h_buffer = ((buffer[0]-48)*10) + (buffer[1]-48);
    uint8_t m_buffer = ((buffer[2]-48)*10) + (buffer[3]-48);
    uint8_t s_buffer = ((buffer[4]-48)*10) + (buffer[5]-48);

    if(update_mode == 0){
        if(h_buffer == Set_update[0] && m_buffer == Set_update[1] && s_buffer == Set_update[2]){
            SNTP_Connect();
            time_set();
            update_mode = 1;
            printf("Time Update Completed.\n\r\n\r");
        }
    }
    else if(update_mode == 1){
        if(!(h_buffer == Set_update[0] && m_buffer == Set_update[1] && s_buffer == Set_update[2])){
            update_mode = 0;
        }
    }
}
float update_sht11(uint8_t sensor_sel){
    sensor.update();
    sensor.setScale(false);
    if(sensor_sel == 0) return sensor.getTemperature();
    else if(sensor_sel == 1) return sensor.getHumidity();
}

int main() {    
    pc.baud(115200);
    wait(0.1);
    printf("\n\rHello WIZwiki-W7500!\n\r");
    printf("===========================================\n\r");
    led1 = led2 = 1;
    
    Seg_Reset();
    SW1.fall(&SW1_Interrupt);
    
    sensor.setOTPReload(false);
    sensor.setResolution(true); 

    eth.init(mac_addr); //Use DHCP
    printf("Check Ethernet Link\r\n");
    while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }
    printf("Link up\r\n");
    eth.connect();
    printf("My IP Address is %s\r\n", eth.getIPAddress());
    
    SNTP_Connect();
    time_set();
    
    //ymd_buffer[0]~[3] : Year
    //ymd_buffer[4]~[5] : Month
    //ymd_buffer[6]~[7] : Day
    char ymd_buffer[8];
    //hms_buffer[0]~[1] : Hour
    //hms_buffer[2]~[3] : Minute
    //hms_buffer[4]~[5] : Second
    char hms_buffer[6];
    
    float temp_val = 0;
    float humi_val = 0;
    int temp_mode = 0;
    int humi_mode = 0;
    
    while(1) {
        time_t seconds = time(NULL);
        
        strftime(hms_buffer, 6, "%H%M%S\n\r", localtime(&seconds));
        strftime(ymd_buffer, 8, "%Y%m%d%\n\r", localtime(&seconds));
        
        if(hms_buffer[4] == '0' && hms_buffer[5] == '0'){
            time_update(hms_buffer);
        }
        if(display_mode == 0) {
            SW_toggle = 0;
            display_hms(hms_buffer);
        }
        else if(display_mode == 1) {
            SW_toggle = 0;
            display_ymd(ymd_buffer);
        }
        else if(display_mode == 2) {
            if(temp_mode == 0){
                if(hms_buffer[5]%5 == 0){
                    temp_val = update_sht11(0);
                    temp_mode = 1;
                }
            }
            if(temp_mode == 1){
                if(hms_buffer[5]%5 != 0){
                    temp_mode = 0;
                }
            }
            display_temp(temp_val);
        }
        else if(display_mode == 3) {
            if(humi_mode == 0){
                if(hms_buffer[5]%5 == 0){
                    humi_val = update_sht11(1);
                    humi_mode = 1;
                }
            }
            if(temp_mode == 1){
                if(hms_buffer[5]%5 != 0){
                    humi_mode = 0;
                }
            }
            display_humi(humi_val);
        }
        else {
            display_hms(hms_buffer);
        }
        //Seg_Test_2();
    }
}