#include "mbed.h"
Timer t;

DigitalOut ledR0(LED_RED);
DigitalOut ledG0(LED_GREEN);
DigitalOut ledB0(LED_BLUE);

DigitalOut led0(D5);
DigitalOut led1(D6);

DigitalIn PIR(D8);
AnalogIn CDS(A0);

Serial pc(USBTX, USBRX);

#define PLED_ON      led0 = led1 = 1
#define PLED_OFF     led0 = led1 = 0

int CDS_data;
int PIR_sensor;

int CDS_check()
{
    CDS_data = CDS.read()*1000;
    //CDS_vol = CDS_data*3.3;
    
    if(CDS_data > 600){
        //ledG0 = 1;
        return 1;
    }
    else {
        //ledG0 = 0;
        return 0;
    }
}

int PIR_check()
{
    PIR_sensor = PIR;
    return PIR_sensor;
}

int main()
{
    ledR0 = ledG0 = ledB0 = 1;
    PLED_OFF;
    unsigned char flag = 1;
    int csd_int = 2;
    int pir_int0 = 2;
    int pir_int1 = 2;
    int pir_status = 0;
    
    pc.baud(115200);
    wait(0.5f);
    pc.printf("Hello mbed!\n\r");
    pc.printf("===========================================\n\r");
    
    while (true) {
        if(CDS_check()){
            if(csd_int != 0){
                pc.printf("Dark now.\r\n");
                csd_int = 0;
            }
            ledG0 = 0;
            flag = 1;
            while(flag){
                if(PIR_check()){
                    if(pir_int0 != 0){
                        pc.printf("The movement is detected.\r\n");
                        pc.printf("Power LED is turned on.\r\n");
                        pc.printf("===========================================\n\r");
                        pir_int0 = 0;
                    }
                    t.stop();
                    t.reset();
                    t.start();
                    pir_status = 1;
                    ledR0 = 0;
                    PLED_ON;
                }
                if(pir_status == 0) {
                    flag = 0;
                }
                if(t.read_ms() > 5000 && pir_status == 1){
                    if(pir_int0 != 1){
                        pc.printf("The movement is not detected.\r\n");
                        pc.printf("Power LED is turned off.\r\n");
                        pc.printf("===========================================\n\r");
                        pir_int0 = 1;
                    }
                    t.stop();
                    t.reset();
                    pir_status = 0;
                    ledR0 = 1;
                    PLED_OFF;
                    flag = 0;
                }
            }
        }
        else{
            if(csd_int != 1){
                pc.printf("Brighter now.\r\n");
                csd_int = 1;
            }
            
            ledG0 = 1;
            if(PIR_check()){
                if(pir_int1 != 0){
                    pc.printf("The movement is detected.\r\n");
                    pir_int1 = 0;
                }
                ledB0 = 0;
            }
            else{
                if(pir_int1 != 1){
                    pc.printf("The movement is not detected.\r\n");
                    pir_int1 = 1;
                }
                ledB0 = 1;
            }
        }
        
        //pc.printf("===========================================\n\r");
        //ledB0 = !ledB0;
        //wait(1);
    }
}
